/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.db.sql.query;

import com.google.urlassistant.datalayer.db.dao.IntentFilterDao;
import com.google.urlassistant.datalayer.db.table.DisposableConnection;
import com.google.urlassistant.datalayer.model.intentfilter.ActivityConfig;
import com.google.urlassistant.datalayer.model.intentfilter.DataTagsConfig;
import com.google.urlassistant.datalayer.model.intentfilter.IntentFilterConfig;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a(\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a(\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u00a8\u0006\u0011"}, d2={"getAllIntentFilters", "", "Lcom/google/urlassistant/datalayer/db/dao/IntentFilterDao;", "connection", "Lcom/google/urlassistant/datalayer/db/table/DisposableConnection;", "Ljava/sql/Connection;", "getIntentFilterByLocation", "startOffset", "", "endOffset", "manifestFile", "", "getIntentFiltersAndClose", "resultSet", "Ljava/sql/ResultSet;", "getIntentFiltersByActivityName", "activityName", "url-assistant"})
public final class IntentFiltersQueryUtilsKt {
    @NotNull
    public static final List<IntentFilterDao> getIntentFiltersAndClose(@NotNull ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        List res = new ArrayList();
        while (resultSet.next()) {
            String string = resultSet.getString("internal_intent_filter_id");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultSet.getString(\"internal_intent_filter_id\")");
            int intentFilterId = Integer.parseInt(string);
            String string2 = resultSet.getString("start_offset");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resultSet.getString(\"start_offset\")");
            int startOffset = Integer.parseInt(string2);
            String string3 = resultSet.getString("end_offset");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resultSet.getString(\"end_offset\")");
            int endOffset = Integer.parseInt(string3);
            String string4 = resultSet.getString("activity_config");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resultSet.getString(\"activity_config\")");
            ActivityConfig activityConfig = ActivityConfig.Companion.fromJson(string4);
            String string5 = resultSet.getString("intent_filter_config");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"resultSet.getString(\"intent_filter_config\")");
            IntentFilterConfig intentFilterConfig = IntentFilterConfig.Companion.fromJson(string5);
            String string6 = resultSet.getString("data_tags_config");
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"resultSet.getString(\"data_tags_config\")");
            DataTagsConfig dataTagsConfig = DataTagsConfig.Companion.fromJson(string6);
            String fileLocation = resultSet.getString("manifest_file_location");
            Integer n = intentFilterId;
            Intrinsics.checkNotNullExpressionValue((Object)fileLocation, (String)"fileLocation");
            res.add(new IntentFilterDao(n, startOffset, endOffset, activityConfig, intentFilterConfig, dataTagsConfig, fileLocation));
        }
        resultSet.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<IntentFilterDao> getAllIntentFilters(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            ResultSet resultSet = it.executeQuery("SELECT * FROM intent_filters");
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"it.executeQuery(\"SELECT \u2026ENT_FILTERS_TABLE_NAME}\")");
            List<IntentFilterDao> list = IntentFiltersQueryUtilsKt.getIntentFiltersAndClose(resultSet);
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final List<IntentFilterDao> getAllIntentFilters(@NotNull DisposableConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return IntentFiltersQueryUtilsKt.getAllIntentFilters(connection.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final IntentFilterDao getIntentFilterByLocation(int startOffset, int endOffset, @NotNull String manifestFile, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)manifestFile, (String)"manifestFile");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            ResultSet resultSet = it.executeQuery("SELECT * FROM intent_filters WHERE start_offset = " + startOffset + " AND end_offset = " + endOffset + " AND manifest_file_location = '" + manifestFile + "'");
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"it.executeQuery(\n       \u2026 '$manifestFile'\"\n      )");
            List<IntentFilterDao> matchingIntentFilters = IntentFiltersQueryUtilsKt.getIntentFiltersAndClose(resultSet);
            if (matchingIntentFilters.size() != 1) {
                throw new AssertionError((Object)("Expected there to be exactly 1 intent filter with start_offset = " + startOffset + " AND end_offset = " + endOffset + " AND manifest_file_location = '" + manifestFile + "'"));
            }
            IntentFilterDao intentFilterDao = matchingIntentFilters.get(0);
            return intentFilterDao;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final IntentFilterDao getIntentFilterByLocation(int startOffset, int endOffset, @NotNull String manifestFile, @NotNull DisposableConnection connection) {
        Intrinsics.checkNotNullParameter((Object)manifestFile, (String)"manifestFile");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return IntentFiltersQueryUtilsKt.getIntentFilterByLocation(startOffset, endOffset, manifestFile, connection.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<IntentFilterDao> getIntentFiltersByActivityName(@NotNull String activityName, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            ResultSet resultSet = it.executeQuery("SELECT * FROM intent_filters WHERE json_extract(activity_config, '$.activityName') = '" + activityName + "'");
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"it.executeQuery(\n       \u2026 '$activityName'\"\n      )");
            List<IntentFilterDao> list = IntentFiltersQueryUtilsKt.getIntentFiltersAndClose(resultSet);
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final List<IntentFilterDao> getIntentFiltersByActivityName(@NotNull String activityName, @NotNull DisposableConnection connection) {
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return IntentFiltersQueryUtilsKt.getIntentFiltersByActivityName(activityName, connection.getConnection());
    }
}

