/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.webp;

import com.android.tools.adtui.webp.WebpMetadata;
import com.android.tools.adtui.webp.WebpNativeLibHelper;
import com.google.webp.libwebp;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpImageReaderSpi
extends ImageReaderSpi {
    private static final byte[] RIFF_HEADER = new byte[]{82, 73, 70, 70};
    private static final byte[] WEBP_HEADER = new byte[]{87, 69, 66, 80};
    private static final int MAX_FILE_SIZE = 0x6400000;

    WebpImageReaderSpi() {
        this.vendorName = "Google LLC";
        this.version = WebpNativeLibHelper.getDecoderVersion();
        this.suffixes = WebpMetadata.WEBP_SUFFIXES;
        this.names = WebpMetadata.WEBP_FORMAT_NAMES;
        this.MIMETypes = WebpMetadata.WEBP_MIME_TYPES;
        this.pluginClassName = WebpReader.class.getName();
        this.inputTypes = new Class[]{ImageInputStream.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(@NotNull Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)source;
        long length = stream.length();
        if (length > 0x6400000L) {
            return false;
        }
        stream.mark();
        try {
            byte[] header = new byte[12];
            int bytesRead = stream.read(header, 0, 12);
            boolean bl = bytesRead == 12 && WebpImageReaderSpi.arrayEquals(header, 0, RIFF_HEADER.length, RIFF_HEADER) && WebpImageReaderSpi.arrayEquals(header, 8, WEBP_HEADER.length, WEBP_HEADER) && WebpNativeLibHelper.loadNativeLibraryIfNeeded();
            return bl;
        }
        finally {
            try {
                stream.reset();
            }
            catch (IOException e) {
                Logger.getInstance(WebpImageReaderSpi.class).error((Throwable)e);
            }
        }
    }

    private static boolean arrayEquals(byte[] a1, int offset, int len, byte[] a2) {
        for (int i = 0; i < len; ++i) {
            if (a1[offset + i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ImageReader createReaderInstance(Object extension) throws IOException {
        WebpNativeLibHelper.requireNativeLibrary();
        return new WebpReader(this);
    }

    @Override
    @NotNull
    public String getDescription(Locale locale) {
        return "Webp Image Decoder";
    }

    private static class WebpReader
    extends ImageReader {
        private static final String UNABLE_TO_READ_WEBP_IMAGE = "Unable to read WebP image";
        private byte[] myInputBytes;
        private final int[] myWidthOut = new int[1];
        private final int[] myHeightOut = new int[1];
        private int myError;

        private WebpReader(ImageReaderSpi originatingProvider) {
            super(originatingProvider);
        }

        @Override
        public void dispose() {
            this.myInputBytes = null;
        }

        @Override
        public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
            super.setInput(input, seekForwardOnly, ignoreMetadata);
            this.myInputBytes = null;
            this.myError = 0;
        }

        @Override
        public int getNumImages(boolean allowSearch) {
            return this.myInputBytes == null ? 0 : 1;
        }

        private void loadInfoIfNeeded() throws IOException {
            if (this.input != null && this.myInputBytes == null) {
                this.myInputBytes = WebpReader.readStreamFully((ImageInputStream)this.input);
                this.myError = libwebp.WebPGetInfo(this.myInputBytes, this.myInputBytes.length, this.myWidthOut, this.myHeightOut);
            }
        }

        private static byte[] readStreamFully(@NotNull ImageInputStream stream) throws IOException {
            int idx;
            if (stream.length() != -1L) {
                byte[] bytes = new byte[(int)stream.length()];
                stream.readFully(bytes);
                return bytes;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(0x100000);
            int bufferSize = 16384;
            byte[] bytes = new byte[16384];
            for (idx = 0; idx < 6400; ++idx) {
                int read = stream.read(bytes, 0, 16384);
                buffer.write(bytes, 0, read);
                if (read != 16384) break;
            }
            if (idx == 6400) {
                throw new IOException("webp image too large");
            }
            return buffer.toByteArray();
        }

        @Override
        public int getWidth(int imageIndex) throws IOException {
            this.loadInfoIfNeeded();
            if (this.myError != 0) {
                return this.myWidthOut[0];
            }
            throw new IOException(UNABLE_TO_READ_WEBP_IMAGE);
        }

        @Override
        public int getHeight(int imageIndex) throws IOException {
            this.loadInfoIfNeeded();
            if (this.myError != 0) {
                return this.myHeightOut[0];
            }
            throw new IOException(UNABLE_TO_READ_WEBP_IMAGE);
        }

        @Override
        @Nullable
        public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) {
            return null;
        }

        @Override
        @Nullable
        public IIOMetadata getStreamMetadata() {
            return null;
        }

        @Override
        @Nullable
        public IIOMetadata getImageMetadata(int imageIndex) {
            return null;
        }

        @Override
        @NotNull
        public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
            this.loadInfoIfNeeded();
            if (this.myError == 0) {
                throw new IOException(UNABLE_TO_READ_WEBP_IMAGE);
            }
            assert (this.myInputBytes != null);
            byte[] argb = libwebp.WebPDecodeARGB(this.myInputBytes, this.myInputBytes.length, this.myWidthOut, this.myHeightOut);
            BufferedImage bi = new BufferedImage(this.myWidthOut[0], this.myHeightOut[0], 2);
            int[] a = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
            IntBuffer intBuf = ByteBuffer.wrap(argb).asIntBuffer();
            assert (a.length == intBuf.remaining());
            intBuf.get(a);
            return bi;
        }
    }
}

