/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ErrorReporter {
    private static final String ERROR_FILE = "coverage-error.log";
    private static final SimpleDateFormat myDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static String basePath;
    public static final int INFO = 0;
    public static final int ERROR = 2;
    private static int myLogLevel;

    public static synchronized void reportError(String message) {
        PrintStream os = null;
        try {
            os = ErrorReporter.getErrorLogStream();
            StringBuffer buf = ErrorReporter.prepareMessage(message);
            System.err.println(buf.toString());
            os.println(buf.toString());
        }
        catch (IOException e) {
            System.err.println("Failed to write to error log file: " + e.toString());
        }
        finally {
            CoverageIOUtil.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void reportError(String message, Throwable t) {
        PrintStream os = null;
        try {
            os = ErrorReporter.getErrorLogStream();
            StringBuffer buf = ErrorReporter.prepareMessage(message);
            System.err.println(buf.toString() + ": " + t.toString());
            os.println(buf.toString());
            t.printStackTrace(os);
        }
        catch (IOException e) {
            System.err.println("Failed to write to error log file: " + e.toString());
            System.err.println("Initial stack trace: " + t.toString());
        }
        finally {
            CoverageIOUtil.close(os);
        }
    }

    public static synchronized void logError(String message) {
        System.err.println(message);
    }

    public static void logInfo(String message) {
        if (myLogLevel > 0) {
            return;
        }
        System.out.println(message);
    }

    private static PrintStream getErrorLogStream() throws FileNotFoundException {
        return new PrintStream(new FileOutputStream(basePath != null ? new File(basePath, ERROR_FILE) : new File(ERROR_FILE), true));
    }

    private static StringBuffer prepareMessage(String message) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(myDateFormat.format(new Date()));
        buf.append("] (Coverage): ");
        buf.append(message);
        return buf;
    }

    public static void setBasePath(String basePath) {
        ErrorReporter.basePath = basePath;
    }

    public static void setLogLevel(int level) {
        myLogLevel = level;
    }

    static {
        myLogLevel = 0;
    }
}

