/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.structureView.YAMLAliasResolveNodeProvider;
import org.jetbrains.yaml.structureView.YAMLCustomStructureViewFactory;
import org.jetbrains.yaml.structureView.YAMLStructureViewFile;
import org.jetbrains.yaml.structureView.YAMLStructureViewKeyValueDuplicated;
import org.jetbrains.yaml.structureView.YAMLStructureViewKeyValueOriginal;
import org.jetbrains.yaml.structureView.YAMLStructureViewSequenceItemDuplicated;
import org.jetbrains.yaml.structureView.YAMLStructureViewSequenceItemOriginal;

public final class YAMLStructureViewFactory
implements PsiStructureViewFactory {
    static final Icon ALIAS_ICON = AllIcons.Nodes.Alias;

    public YAMLStructureViewFactory() {
        YAMLCustomStructureViewFactory.EP_NAME.addChangeListener(() -> ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(StructureViewWrapperImpl.STRUCTURE_CHANGED)).run(), ExtensionPointUtil.createKeyedExtensionDisposable((Object)this, (ExtensionPoint)PsiStructureViewFactory.EP_NAME.getPoint()));
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        if (!(psiFile instanceof YAMLFile)) {
            return null;
        }
        for (YAMLCustomStructureViewFactory extension : YAMLCustomStructureViewFactory.EP_NAME.getExtensionList()) {
            StructureViewBuilder builder = extension.getStructureViewBuilder((YAMLFile)psiFile);
            if (builder == null) continue;
            return builder;
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new StructureViewModelBase(psiFile, editor, (StructureViewTreeElement)new YAMLStructureViewFile((YAMLFile)psiFile)){

                    @NotNull
                    public Collection<NodeProvider<?>> getNodeProviders() {
                        return Collections.singleton(new YAMLAliasResolveNodeProvider());
                    }
                }.withSorters(new Sorter[]{Sorter.ALPHA_SORTER}).withSuitableClasses(new Class[]{YAMLFile.class, YAMLDocument.class, YAMLKeyValue.class});
            }
        };
    }

    @NotNull
    static String getAliasPresentableText(@NotNull YAMLAlias alias) {
        return "*" + alias.getAliasName();
    }

    @NotNull
    static Collection<StructureViewTreeElement> createChildrenViewTreeElements(@Nullable YAMLPsiElement element, final @Nullable String path) {
        if (element == null) {
            return Collections.emptyList();
        }
        final Ref result = Ref.create(Collections.emptyList());
        element.accept(new YamlPsiElementVisitor(){

            @Override
            public void visitSequence(@NotNull YAMLSequence sequence) {
                result.set((Object)ContainerUtil.map(sequence.getItems(), i -> path == null ? new YAMLStructureViewSequenceItemOriginal((YAMLSequenceItem)i) : new YAMLStructureViewSequenceItemDuplicated((YAMLSequenceItem)i, path)));
            }

            @Override
            public void visitMapping(@NotNull YAMLMapping mapping) {
                result.set((Object)ContainerUtil.map(mapping.getKeyValues(), kv -> path == null ? new YAMLStructureViewKeyValueOriginal((YAMLKeyValue)kv) : new YAMLStructureViewKeyValueDuplicated((YAMLKeyValue)kv, path)));
            }
        });
        return (Collection)result.get();
    }
}

