/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.ActionShortcutProvider;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.resolve.YAMLAliasReference;
import org.jetbrains.yaml.structureView.DuplicatedPsiTreeElementBase;
import org.jetbrains.yaml.structureView.YAMLStructureViewFactory;

public class YAMLAliasResolveNodeProvider
implements FileStructureNodeProvider<StructureViewTreeElement>,
ActionShortcutProvider {
    @NonNls
    public static final String ID = "YAML_SHOW_RESOLVED_ALIAS_VALUES";

    @NotNull
    public String getCheckBoxText() {
        return YAMLBundle.message("YAMLAliasResolveNodeProvider.action.name", new Object[0]);
    }

    public Shortcut @NotNull [] getShortcut() {
        throw new IncorrectOperationException("see getActionIdForShortcut()");
    }

    @NotNull
    public String getActionIdForShortcut() {
        return "FileStructurePopup";
    }

    @NotNull
    public Collection<StructureViewTreeElement> provideNodes(@NotNull TreeElement node) {
        String details;
        Object psiElem;
        if (node instanceof DuplicatedPsiTreeElementBase) {
            yamlNode = (DuplicatedPsiTreeElementBase)node;
            psiElem = yamlNode.getElement();
            details = yamlNode.getDetails();
        } else if (node instanceof PsiTreeElementBase) {
            yamlNode = (PsiTreeElementBase)node;
            psiElem = yamlNode.getElement();
            if (psiElem == null) {
                return Collections.emptyList();
            }
            details = YAMLAliasResolveNodeProvider.calculateStartPath(psiElem);
        } else {
            return Collections.emptyList();
        }
        YAMLPsiElement yamlElem = psiElem instanceof YAMLPsiElement ? (YAMLPsiElement)psiElem : null;
        YAMLValue value = YAMLAliasResolveNodeProvider.getContainedValue(yamlElem);
        if (!(value instanceof YAMLAlias)) {
            return Collections.emptyList();
        }
        return YAMLStructureViewFactory.createChildrenViewTreeElements(YAMLAliasResolveNodeProvider.resolveAlias((YAMLAlias)value), details);
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(YAMLBundle.message("YAMLAliasResolveNodeProvider.action.name", new Object[0]), YAMLBundle.message("YAMLAliasResolveNodeProvider.action.description", new Object[0]), YAMLStructureViewFactory.ALIAS_ICON);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    @Nullable
    private static YAMLValue resolveAlias(@NotNull YAMLAlias alias) {
        YAMLAliasReference ref = alias.getReference();
        YAMLAnchor anchor = ref == null ? null : ref.resolve();
        return anchor != null ? anchor.getMarkedValue() : null;
    }

    @Nullable
    @Contract(value="null -> null")
    private static YAMLValue getContainedValue(@Nullable YAMLPsiElement element) {
        if (element == null) {
            return null;
        }
        final Ref result = Ref.create();
        element.accept(new YamlPsiElementVisitor(){

            @Override
            public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                result.set((Object)keyValue.getValue());
            }

            @Override
            public void visitSequenceItem(@NotNull YAMLSequenceItem sequenceItem) {
                result.set((Object)sequenceItem.getValue());
            }
        });
        return (YAMLValue)result.get();
    }

    @NotNull
    private static String calculateStartPath(@NotNull PsiElement psiElem) {
        if (!(psiElem instanceof YAMLPsiElement)) {
            return "";
        }
        return YAMLUtil.getConfigFullName((YAMLPsiElement)psiElem);
    }
}

