/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.smart;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.smart.YAMLInjectedElementEnterHandlerKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/yaml/smart/YAMLInjectedElementEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.yaml"})
public final class YAMLInjectedElementEnterHandler
extends EnterHandlerDelegateAdapter {
    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        int lineStartOffset;
        Object object = CommonDataKeys.HOST_EDITOR.getData(dataContext);
        EditorEx editorEx = object instanceof EditorEx ? (EditorEx)object : null;
        if (editorEx == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        EditorEx hostEditor = editorEx;
        int caretOffset = hostEditor.getCaretModel().getOffset();
        String string = (String)YAMLInjectedElementEnterHandlerKt.access$getINDENT_BEFORE_PROCESSING$p().get((UserDataHolder)file);
        if (string == null) {
            string = "";
        }
        String injectionIndent = string;
        RangeMarker rangeMarker = (RangeMarker)YAMLInjectedElementEnterHandlerKt.access$getINJECTION_RANGE_BEFORE_ENTER$p().get((UserDataHolder)file);
        if (rangeMarker == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        RangeMarker pointer = rangeMarker;
        DocumentEx document = hostEditor.getDocument();
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
        if (psiLanguageInjectionHost == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiLanguageInjectionHost currentInjectionHost = psiLanguageInjectionHost;
        TextRange currentHostRange = currentInjectionHost.getTextRange();
        TreeSet lines = YAMLInjectedElementEnterHandlerKt.access$linesBetween((Document)document, currentHostRange.getEndOffset(), pointer.getEndOffset());
        pointer.dispose();
        YAMLInjectedElementEnterHandlerKt.access$getINJECTION_RANGE_BEFORE_ENTER$p().set((UserDataHolder)file, null);
        int caretLine = document.getLineNumber(caretOffset);
        lines.add(caretLine);
        TreeSet<Integer> linesToAdjustIndent = new TreeSet<Integer>();
        for (Integer line : lines) {
            boolean fix;
            lineStartOffset = document.getLineStartOffset(line.intValue());
            CharSequence lineChars = document.getCharsSequence().subSequence(lineStartOffset, document.getLineEndOffset(line.intValue()));
            int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)lineChars, (CharSequence)injectionIndent);
            boolean bl = fix = !StringsKt.startsWith$default((CharSequence)lineChars, (CharSequence)injectionIndent, (boolean)false, (int)2, null);
            if (fix) {
                document.replaceString(lineStartOffset, lineStartOffset + commonPrefixLength, (CharSequence)injectionIndent);
                Integer n = line;
                int n2 = caretLine;
                if (n != null && n == n2) {
                    hostEditor.getCaretModel().moveToOffset(lineStartOffset + injectionIndent.length());
                }
            }
            if (!fix && (!StringsKt.isBlank((CharSequence)lineChars) || Intrinsics.areEqual(lines.last(), (Object)line))) continue;
            linesToAdjustIndent.add(line);
        }
        for (Integer line : linesToAdjustIndent) {
            lineStartOffset = document.getLineStartOffset(line.intValue());
            int forward = StringUtil.skipWhitespaceForward((CharSequence)document.getCharsSequence(), (int)lineStartOffset);
            CodeStyleManager.getInstance((Project)file.getProject()).adjustLineIndent((Document)document, forward);
        }
        return EnterHandlerDelegate.Result.Continue;
    }
}

