/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.smart;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementType;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTextUtil;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;
import org.jetbrains.yaml.refactoring.rename.YamlKeyValueRenameInputValidator;
import org.jetbrains.yaml.smart.YAMLEditorOptions;

public class YAMLCopyPasteProcessor
implements CopyPastePreProcessor {
    private static final String CONFIG_KEY_SEQUENCE_PATTERN = "\\.*([^\\s{}\\[\\].][^\\s.]*\\.)+[^\\s{}\\[\\].][^\\s.]*:?\\s*";

    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        boolean inTheStartOfSubElement;
        if (startOffsets.length != 1 || endOffsets.length != 1) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        int caretOffset = startOffsets[0];
        PsiElement element = file.findElementAt(caretOffset);
        if (element == null) {
            return null;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true);
        if (prevLeaf instanceof PsiWhiteSpace) {
            prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)prevLeaf, (boolean)true);
        }
        if (element instanceof PsiWhiteSpace && (element = PsiTreeUtil.nextLeaf((PsiElement)element, (boolean)true)) == null) {
            return null;
        }
        boolean bl = inTheStartOfSubElement = YAMLCopyPasteProcessor.isYamlElementType(element) && PsiUtilCore.getElementType((PsiElement)element) == YAMLTokenTypes.INDENT || element.getTextRange().getStartOffset() == caretOffset && YAMLCopyPasteProcessor.isYamlElementType(prevLeaf) && PsiUtilCore.getElementType((PsiElement)prevLeaf) == YAMLTokenTypes.INDENT || element.getTextRange().getStartOffset() >= caretOffset && YAMLCopyPasteProcessor.isYamlElementType(prevLeaf) && PsiUtilCore.getElementType((PsiElement)prevLeaf) == YAMLTokenTypes.SEQUENCE_MARKER;
        if (!inTheStartOfSubElement) {
            return null;
        }
        int lineStartOffset = DocumentUtil.getLineStartOffset((int)caretOffset, (Document)document);
        if (lineStartOffset == caretOffset) {
            return null;
        }
        PsiElement borderParent = PsiTreeUtil.findFirstParent((PsiElement)PsiTreeUtil.nextLeaf((PsiElement)element, (boolean)false), (boolean)true, psi -> psi instanceof YAMLBlockSequenceImpl || psi instanceof YAMLBlockMappingImpl);
        if (borderParent == null) {
            return null;
        }
        int endOffset = endOffsets[0];
        PsiElement endElement = file.findElementAt(endOffset - 1);
        if (endElement != null && YAMLUtil.psiAreAtTheSameLine(element, endElement)) {
            return null;
        }
        if (borderParent.getTextRange().getEndOffset() < endOffset) {
            PsiElement nextElement = borderParent;
            while ((nextElement = PsiTreeUtil.nextLeaf((PsiElement)nextElement, (boolean)true)) != null && nextElement.getTextRange().getStartOffset() < endOffset) {
                IElementType elementType = PsiUtilCore.getElementType((PsiElement)nextElement);
                if (!(elementType instanceof YAMLElementType)) {
                    return null;
                }
                if (YAMLElementTypes.BLANK_ELEMENTS.contains(elementType)) continue;
                return null;
            }
        }
        return StringUtil.repeatSymbol((char)' ', (int)(caretOffset - lineStartOffset)) + text;
    }

    private static boolean isYamlElementType(PsiElement element) {
        return PsiUtilCore.getElementType((PsiElement)element) instanceof YAMLElementType;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        String specialKeyPaste;
        if (!file.getViewProvider().hasLanguage((Language)YAMLLanguage.INSTANCE)) {
            return text;
        }
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        Document document = editor.getDocument();
        int caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretModel.getOffset();
        int lineNumber = document.getLineNumber(caretOffset);
        int lineStartOffset = YAMLTextUtil.getLineStartSafeOffset(document, lineNumber);
        int indent = caretOffset - lineStartOffset;
        boolean smartPaste = YAMLEditorOptions.getInstance().isUseSmartPaste();
        String string = specialKeyPaste = smartPaste ? YAMLCopyPasteProcessor.tryToPasteAsKeySequence(text, file, editor, caretOffset, indent) : null;
        if (specialKeyPaste != null) {
            return specialKeyPaste;
        }
        if (indent == 0 || !YAMLCopyPasteProcessor.canBeInsertedWithIndentAdjusted(file, caretOffset)) {
            return text;
        }
        return YAMLCopyPasteProcessor.indentText(text, StringUtil.repeatSymbol((char)' ', (int)indent), YAMLCopyPasteProcessor.shouldInsertIndentAtTheEnd(caretOffset, document));
    }

    private static boolean shouldInsertIndentAtTheEnd(int caretOffset, Document document) {
        for (int i = caretOffset; i < document.getTextLength(); ++i) {
            char c = document.getCharsSequence().charAt(i);
            if (c == '\n') {
                return false;
            }
            if (Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canBeInsertedWithIndentAdjusted(PsiFile file, int caretOffset) {
        PsiElement previousElement;
        PsiElement element = file.findElementAt(caretOffset);
        if (element != null) {
            if (PsiUtilCore.getElementType((PsiElement)element) == YAMLTokenTypes.SCALAR_LIST) return false;
            if (PsiUtilCore.getElementType((PsiElement)element.getParent()) == YAMLElementTypes.SCALAR_LIST_VALUE) {
                return false;
            }
            TokenSet ends = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.EOL, YAMLTokenTypes.SCALAR_EOL, YAMLTokenTypes.COMMENT});
            IElementType nextType = PsiUtilCore.getElementType((PsiElement)element.getNextSibling());
            if (PsiUtilCore.getElementType((PsiElement)element) == YAMLTokenTypes.INDENT) {
                if (nextType == null) return true;
                if (ends.contains(nextType)) {
                    return true;
                }
            }
        }
        if (element == null) {
            if (caretOffset <= 0) return true;
            previousElement = file.findElementAt(caretOffset - 1);
        } else {
            previousElement = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true);
        }
        if (PsiUtilCore.getElementType((PsiElement)previousElement) == TokenType.WHITE_SPACE) {
            previousElement = PsiTreeUtil.prevLeaf((PsiElement)previousElement, (boolean)true);
        }
        if (PsiUtilCore.getElementType((PsiElement)previousElement) == YAMLTokenTypes.INDENT) return true;
        if (PsiUtilCore.getElementType((PsiElement)previousElement) == YAMLTokenTypes.EOL) return true;
        if (PsiUtilCore.getElementType((PsiElement)previousElement) != YAMLTokenTypes.SEQUENCE_MARKER) return false;
        return true;
    }

    @NotNull
    private static String indentText(@NotNull String text, @NotNull String curLineIndent, boolean shouldInsertIndentInTheEnd) {
        List lines = LineTokenizer.tokenizeIntoList((CharSequence)text, (boolean)false, (boolean)false);
        if (lines.isEmpty()) {
            return text;
        }
        int minIndent = YAMLCopyPasteProcessor.calculateMinBlockIndent(lines);
        String firstLine = (String)lines.iterator().next();
        if (lines.size() == 1) {
            return firstLine;
        }
        String suffixIndent = shouldInsertIndentInTheEnd && YAMLCopyPasteProcessor.isEmptyLine((String)lines.get(lines.size() - 1)) ? curLineIndent : "";
        return firstLine.substring(YAMLTextUtil.getStartIndentSize(firstLine)) + "\n" + lines.stream().skip(1L).map(line -> {
            if (!YAMLCopyPasteProcessor.isEmptyLine(line)) {
                return curLineIndent + line.substring(minIndent);
            }
            return "";
        }).reduce((left, right) -> left + "\n" + right).orElse("") + suffixIndent;
    }

    private static int calculateMinBlockIndent(@NotNull List<String> list) {
        Iterator<String> it = list.iterator();
        String str = "";
        while (it.hasNext() && YAMLCopyPasteProcessor.isEmptyLine(str = it.next())) {
        }
        if (!it.hasNext()) {
            return 0;
        }
        int minIndent = YAMLTextUtil.getStartIndentSize(str);
        while (it.hasNext()) {
            str = it.next();
            if (YAMLCopyPasteProcessor.isEmptyLine(str)) continue;
            minIndent = Math.min(minIndent, YAMLTextUtil.getStartIndentSize(str));
        }
        return minIndent;
    }

    private static boolean isEmptyLine(@NotNull String str) {
        return YAMLTextUtil.getStartIndentSize(str) == str.length();
    }

    @Nullable
    private static String tryToPasteAsKeySequence(@NotNull String text, @NotNull PsiFile file, @NotNull Editor editor, int caretOffset, int indent) {
        String result;
        if (!text.matches(CONFIG_KEY_SEQUENCE_PATTERN)) {
            return null;
        }
        List<String> keys = YAMLCopyPasteProcessor.separateCompositeKey(text);
        assert (!keys.isEmpty());
        for (String key : keys) {
            if (YamlKeyValueRenameInputValidator.IDENTIFIER_PATTERN.matcher(key).matches()) continue;
            return null;
        }
        PsiElement element = file.findElementAt(caretOffset);
        if (element != null && (result = YAMLCopyPasteProcessor.tryToPasteAsKeySequenceAtMapping(editor, keys, element, caretOffset, indent)) != null) {
            return result;
        }
        if ((element == null || element.getTextRange().getStartOffset() == caretOffset) && caretOffset > 0 && (element = file.findElementAt(caretOffset - 1)) != null) {
            int parentIndent;
            result = YAMLCopyPasteProcessor.tryToPasteAsKeySequenceAtMapping(editor, keys, element, caretOffset, indent);
            if (result != null) {
                return result;
            }
            YAMLKeyValue keyValue = YAMLCopyPasteProcessor.getPreviousKeyValuePairBeforeEOL(element);
            if (keyValue != null && keyValue.getValue() == null && indent > (parentIndent = YAMLUtil.getIndentToThisElement((PsiElement)keyValue))) {
                return YAMLElementGenerator.createChainedKey(keys, indent);
            }
        }
        return null;
    }

    @Nullable
    private static YAMLKeyValue getPreviousKeyValuePairBeforeEOL(@NotNull PsiElement element) {
        PsiElement cur;
        if (PsiUtilCore.getElementType((PsiElement)element.getParent()) != YAMLElementTypes.MAPPING) {
            return null;
        }
        boolean eolMet = false;
        for (cur = element; cur != null && YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)cur)); cur = cur.getPrevSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)cur) != YAMLTokenTypes.EOL) continue;
            eolMet = true;
        }
        if (eolMet && PsiUtilCore.getElementType((PsiElement)cur) == YAMLElementTypes.KEY_VALUE_PAIR) {
            return (YAMLKeyValue)cur;
        }
        return null;
    }

    @Nullable
    private static String tryToPasteAsKeySequenceAtMapping(@NotNull Editor editor, @NotNull List<String> keys, @NotNull PsiElement element, int caretOffset, int indent) {
        while (true) {
            YAMLKeyValue keyValue;
            YAMLBlockMappingImpl blockMapping;
            if (element.getParent() instanceof YAMLFile) {
                PsiElement prev = element.getPrevSibling();
                if (!(prev instanceof YAMLDocument)) {
                    return null;
                }
                element = ((YAMLDocument)prev).getTopLevelValue();
                if (!(element instanceof YAMLBlockMappingImpl)) {
                    return null;
                }
                blockMapping = (YAMLBlockMappingImpl)element;
            } else {
                blockMapping = (YAMLBlockMappingImpl)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLBlockMappingImpl.class);
            }
            if (blockMapping == null) {
                return null;
            }
            int mappingIndent = YAMLUtil.getIndentToThisElement((PsiElement)blockMapping);
            if (mappingIndent == indent && (keyValue = (YAMLKeyValue)ApplicationManager.getApplication().runWriteAction(() -> {
                YAMLKeyValue lastKeyVal = blockMapping.getOrCreateKeySequence(keys, caretOffset);
                if (lastKeyVal == null) {
                    return null;
                }
                ASTNode colon = lastKeyVal.getNode().findChildByType((IElementType)YAMLTokenTypes.COLON);
                if (colon != null) {
                    int newOffset = colon.getTextRange().getEndOffset();
                    editor.getCaretModel().moveToOffset(newOffset);
                }
                return lastKeyVal;
            })) != null) {
                return "";
            }
            element = blockMapping;
        }
    }

    @NotNull
    private static List<String> separateCompositeKey(@NotNull String text) {
        text = text.trim();
        text = StringUtil.trimEnd((String)text, (char)':');
        int leadingDotsNumber = StringUtil.countChars((CharSequence)text, (char)'.', (int)0, (boolean)true);
        String dotPrefix = text.substring(0, leadingDotsNumber);
        text = text.substring(leadingDotsNumber);
        List sequence = StringUtil.split((String)text, (String)".");
        if (!dotPrefix.isEmpty() && sequence.size() > 0) {
            sequence.set(0, dotPrefix + (String)sequence.get(0));
        }
        return sequence;
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        return false;
    }
}

