/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.schema.YamlArrayAdapter;
import org.jetbrains.yaml.schema.YamlEmptyObjectAdapter;
import org.jetbrains.yaml.schema.YamlEmptyValueAdapter;
import org.jetbrains.yaml.schema.YamlGenericValueAdapter;
import org.jetbrains.yaml.schema.YamlObjectAdapter;
import org.jetbrains.yaml.schema.YamlPropertyKeyAdapter;

public class YamlPropertyAdapter
implements JsonPropertyAdapter {
    private final PsiElement myProperty;

    public YamlPropertyAdapter(@NotNull PsiElement property) {
        this.myProperty = property;
    }

    @Nullable
    public String getName() {
        return this.myProperty instanceof YAMLKeyValue ? ((YAMLKeyValue)this.myProperty).getKeyText() : this.myProperty.getText();
    }

    @Nullable
    public JsonValueAdapter getNameValueAdapter() {
        if (!(this.myProperty instanceof YAMLKeyValue)) {
            return null;
        }
        PsiElement key = ((YAMLKeyValue)this.myProperty).getKey();
        if (key == null) {
            return null;
        }
        return new YamlPropertyKeyAdapter(key);
    }

    @NotNull
    public Collection<JsonValueAdapter> getValues() {
        YAMLValue value = this.myProperty instanceof YAMLKeyValue ? ((YAMLKeyValue)this.myProperty).getValue() : null;
        return value != null ? Collections.singletonList(YamlPropertyAdapter.createValueAdapterByType(value)) : ContainerUtil.createMaybeSingletonList((Object)YamlPropertyAdapter.createEmptyValueAdapter(this.myProperty, false));
    }

    @NotNull
    public PsiElement getDelegate() {
        return this.myProperty;
    }

    @Nullable
    public JsonObjectValueAdapter getParentObject() {
        YAMLMapping parentMapping = this.myProperty instanceof YAMLKeyValue ? ((YAMLKeyValue)this.myProperty).getParentMapping() : (YAMLMapping)ObjectUtils.tryCast((Object)this.myProperty.getParent(), YAMLMapping.class);
        return parentMapping != null ? new YamlObjectAdapter(parentMapping) : null;
    }

    @NotNull
    public static JsonValueAdapter createValueAdapterByType(@NotNull YAMLValue value) {
        JsonValueAdapter adapter;
        PsiElement result;
        if (value instanceof YAMLAlias && (result = YamlObjectAdapter.resolveYamlAlias(value)) instanceof YAMLValue && (adapter = (JsonValueAdapter)RecursionManager.doPreventingRecursion((Object)value, (boolean)false, () -> YamlPropertyAdapter.createValueAdapterByType((YAMLValue)result))) != null) {
            return adapter;
        }
        if (value instanceof YAMLMapping) {
            return new YamlObjectAdapter((YAMLMapping)value);
        }
        if (value instanceof YAMLSequence) {
            return new YamlArrayAdapter((YAMLSequence)value);
        }
        return new YamlGenericValueAdapter(value);
    }

    @Nullable
    public static JsonValueAdapter createEmptyValueAdapter(@NotNull PsiElement context, boolean pinSelf) {
        PsiElement next;
        if (context instanceof YAMLKeyValue && ((YAMLKeyValue)context).getValue() == null && PsiUtilCore.getElementType((PsiElement)(next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)context))) == YAMLTokenTypes.EOL && PsiUtilCore.getElementType((PsiElement)(next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)next))) == YAMLTokenTypes.INDENT && !(PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)next) instanceof YAMLKeyValue)) {
            return new YamlEmptyObjectAdapter(next);
        }
        PsiElement nextSibling = context.getNextSibling();
        PsiElement nodeToHighlight = PsiUtilCore.getElementType((PsiElement)nextSibling) == TokenType.WHITE_SPACE ? nextSibling : (pinSelf ? context : context.getLastChild());
        return nodeToHighlight == null ? null : new YamlEmptyValueAdapter(nodeToHighlight);
    }
}

