/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.schema.YamlJsonSchemaInspectionBase;

public class YamlJsonSchemaDeprecationInspection
extends YamlJsonSchemaInspectionBase {
    @Override
    protected PsiElementVisitor doBuildVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, Collection<PsiElement> roots, final JsonSchemaObject schema) {
        PsiElement sampleElement = roots.iterator().next();
        final JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker((PsiElement)sampleElement, (JsonSchemaObject)schema);
        if (walker == null || schema == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        final Project project = sampleElement.getProject();
        return new YamlPsiElementVisitor(){

            @Override
            public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                this.annotate(keyValue);
                super.visitKeyValue(keyValue);
            }

            private void annotate(@NotNull YAMLKeyValue keyValue) {
                PsiElement key = keyValue.getKey();
                if (key == null) {
                    return;
                }
                JsonPointerPosition position = walker.findPosition((PsiElement)keyValue, true);
                if (position == null) {
                    return;
                }
                MatchResult result = new JsonSchemaResolver(project, schema, position).detailedResolve();
                for (JsonSchemaObject object : result.mySchemas) {
                    String message = object.getDeprecationMessage();
                    if (message == null) continue;
                    holder.registerProblem(key, YAMLBundle.message("inspections.schema.deprecation.text", keyValue.getName(), message), new LocalQuickFix[0]);
                    return;
                }
            }
        };
    }
}

