/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLValue;

public final class YamlGenericValueAdapter
implements JsonValueAdapter {
    @NotNull
    private static final Set<String> NULLS = Set.of("null", "Null", "NULL", "~");
    @NotNull
    private static final Set<String> BOOLS = Set.of("true", "True", "TRUE", "false", "False", "FALSE");
    @NotNull
    private static final Set<String> INFS = Set.of(".inf", ".Inf", ".INF");
    @NotNull
    private static final Set<String> NANS = Set.of(".nan", ".NaN", ".NAN");
    @NotNull
    private final YAMLValue myValue;

    public YamlGenericValueAdapter(@NotNull YAMLValue value) {
        this.myValue = value;
    }

    public boolean isShouldBeIgnored() {
        return true;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isStringLiteral() {
        return !this.isNumberLiteral() && !this.isBooleanLiteral() && !this.isNull();
    }

    private String getTextWithoutRefs() {
        YAMLAnchor[] anchors = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)this.myValue, YAMLAnchor.class);
        if (anchors == null || anchors.length == 0) {
            return this.myValue.getText();
        }
        int endOffset = anchors[anchors.length - 1].getTextRange().getEndOffset();
        TextRange valueTextRange = this.myValue.getTextRange();
        int offset = valueTextRange.getEndOffset();
        TextRange range = new TextRange(endOffset, offset);
        range = range.shiftLeft(valueTextRange.getStartOffset());
        String text = this.myValue.getText();
        return text.substring(range.getStartOffset()).trim();
    }

    private static boolean hasTag(@NotNull String text, @NotNull String tagName) {
        return StringUtil.startsWith((CharSequence)text, (CharSequence)("!!" + tagName));
    }

    public boolean isNumberLiteral() {
        String text = this.getTextWithoutRefs();
        return YamlGenericValueAdapter.isNumber(text);
    }

    public boolean isBooleanLiteral() {
        String text = this.getTextWithoutRefs();
        return BOOLS.contains(text) || YamlGenericValueAdapter.hasTag(text, "bool");
    }

    public boolean isNull() {
        String text = this.getTextWithoutRefs();
        return NULLS.contains(text) || YamlGenericValueAdapter.hasTag(text, "null");
    }

    @NotNull
    public PsiElement getDelegate() {
        return this.myValue;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return null;
    }

    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }

    public boolean shouldCheckIntegralRequirements() {
        return false;
    }

    private static boolean isNumber(@Nullable String s) {
        if (s == null) {
            return false;
        }
        return YamlGenericValueAdapter.isInteger(s) || YamlGenericValueAdapter.isFloat(s);
    }

    private static boolean isInteger(@NotNull String s) {
        if (s.length() == 0) {
            return false;
        }
        if ("0".equals(s) || "-0".equals(s) || "+0".equals(s)) {
            return true;
        }
        if (YamlGenericValueAdapter.hasTag(s, "int")) {
            return true;
        }
        return YamlGenericValueAdapter.matchesInt(s);
    }

    private static boolean matchesInt(@NotNull String s) {
        char charZero = s.charAt(0);
        int startIndex = charZero == '-' || charZero == '+' ? 1 : 0;
        int baseSign = 32;
        boolean expectBase = false;
        for (int i = startIndex; i < s.length(); ++i) {
            if (i == startIndex && s.charAt(i) == '0') {
                if (startIndex != 0) {
                    return false;
                }
                expectBase = true;
                continue;
            }
            if (i == startIndex + 1 && expectBase) {
                char c = s.charAt(i);
                if (c != 'o' && c != 'x') {
                    return false;
                }
                baseSign = c;
            }
            if (baseSign == 32 && !Character.isDigit(s.charAt(i))) {
                return false;
            }
            if (baseSign == 111 && !StringUtil.isOctalDigit((char)s.charAt(i))) {
                return false;
            }
            if (baseSign != 120 || StringUtil.isHexDigit((char)s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isFloat(@NotNull String s) {
        if (INFS.contains(YamlGenericValueAdapter.trimSign(s)) || NANS.contains(s)) {
            return true;
        }
        if (YamlGenericValueAdapter.hasTag(s, "float")) {
            return true;
        }
        return Pattern.matches("[-+]?(\\.[0-9]+|[0-9]+(\\.[0-9]*)?)([eE][-+]?[0-9]+)?", s);
    }

    @NotNull
    private static String trimSign(@NotNull String s) {
        if (s.isEmpty()) {
            return s;
        }
        char c = s.charAt(0);
        return c == '+' || c == '-' ? s.substring(1) : s;
    }
}

