/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.schema.YamlPropertyAdapter;

public final class YamlArrayAdapter
implements JsonArrayValueAdapter {
    @NotNull
    private final YAMLSequence myArray;
    @NotNull
    private final NotNullLazyValue<List<JsonValueAdapter>> myChildAdapters = NotNullLazyValue.lazy(this::computeChildAdapters);

    public YamlArrayAdapter(@NotNull YAMLSequence array) {
        this.myArray = array;
    }

    @NotNull
    public List<JsonValueAdapter> getElements() {
        return (List)this.myChildAdapters.getValue();
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        PsiElement tag = this.myArray.getTag();
        return tag == null || "!!seq".equals(tag.getText());
    }

    public boolean isStringLiteral() {
        return false;
    }

    public boolean isNumberLiteral() {
        return false;
    }

    public boolean isBooleanLiteral() {
        return false;
    }

    @NotNull
    public PsiElement getDelegate() {
        return this.myArray;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return null;
    }

    @NotNull
    public JsonArrayValueAdapter getAsArray() {
        return this;
    }

    @NotNull
    private List<JsonValueAdapter> computeChildAdapters() {
        List<YAMLSequenceItem> items = this.myArray.getItems();
        ArrayList<JsonValueAdapter> adapters = new ArrayList<JsonValueAdapter>(items.size());
        for (YAMLSequenceItem item : items) {
            YAMLValue value = item.getValue();
            if (value == null) {
                JsonValueAdapter emptyAdapter = YamlPropertyAdapter.createEmptyValueAdapter(item.getFirstChild(), true);
                if (emptyAdapter == null) continue;
                adapters.add(emptyAdapter);
                continue;
            }
            adapters.add(YamlPropertyAdapter.createValueAdapterByType(value));
        }
        return adapters;
    }
}

