/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.ProcessingContext;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public final class YamlKeyValueRenameInputValidator
implements RenameInputValidatorEx {
    private static final String IDENTIFIER_START_PATTERN = "(([^\\n\\t\\r \\-?:,\\[\\]{}#&*!|>'\"%@`])|([?:-][^\\n\\t\\r ]))";
    private static final String IDENTIFIER_END_PATTERN = "(([^\\n\\t\\r ]#)|([^\\n\\t\\r :#])|(:[^\\n\\t\\r ]))";
    public static final Pattern IDENTIFIER_PATTERN = Pattern.compile("((([^\\n\\t\\r \\-?:,\\[\\]{}#&*!|>'\"%@`])|([?:-][^\\n\\t\\r ]))([ \t]*(([^\\n\\t\\r ]#)|([^\\n\\t\\r :#])|(:[^\\n\\t\\r ])))*)|('[^\\n']*')|(\"[^\\n\"]*\")");

    @Nullable
    public String getErrorMessage(@NotNull String newName, @NotNull Project project) {
        return IDENTIFIER_PATTERN.matcher(newName).matches() ? null : YAMLBundle.message("rename.invalid.name", newName);
    }

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        return PlatformPatterns.psiElement(YAMLKeyValue.class);
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        return true;
    }
}

