/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLBlockScalar;
import org.jetbrains.yaml.psi.YAMLScalarText;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarTextEvaluator;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

public class YAMLScalarTextImpl
extends YAMLBlockScalarImpl
implements YAMLScalarText,
YAMLBlockScalar {
    public YAMLScalarTextImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    protected IElementType getContentType() {
        return YAMLTokenTypes.SCALAR_TEXT;
    }

    @Override
    @NotNull
    public YamlScalarTextEvaluator<YAMLScalarTextImpl> getTextEvaluator() {
        return new YAMLBlockScalarTextEvaluator<YAMLScalarTextImpl>(this){

            @Override
            @NotNull
            protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges2, int indexBefore) {
                TextRange leftRange = contentRanges2.get(indexBefore);
                TextRange rightRange = contentRanges2.get(indexBefore + 1);
                if (leftRange.isEmpty()) {
                    if (rightRange.getLength() == 1 && text.charAt(rightRange.getStartOffset()) == '\n' && this.getChompingIndicator() != YAMLBlockScalarTextEvaluator.ChompingIndicator.KEEP) {
                        return "";
                    }
                    return "\n";
                }
                if (this.startsWithWhitespace(text, leftRange) || this.startsWithWhitespace(text, rightRange)) {
                    return "\n";
                }
                if (rightRange.isEmpty()) {
                    int i;
                    for (i = indexBefore + 2; i < contentRanges2.size() && contentRanges2.get(i).isEmpty(); ++i) {
                    }
                    if (i >= contentRanges2.size() ? this.getChompingIndicator() == YAMLBlockScalarTextEvaluator.ChompingIndicator.KEEP : this.startsWithWhitespace(text, contentRanges2.get(i))) {
                        return "\n";
                    }
                    return "";
                }
                return " ";
            }

            @Override
            @NotNull
            public String getTextValue(@Nullable TextRange rangeInHost) {
                Object value = super.getTextValue(rangeInHost);
                if (!StringUtil.isEmptyOrSpaces((String)value) && this.getChompingIndicator() != YAMLBlockScalarTextEvaluator.ChompingIndicator.STRIP && this.isEnding(rangeInHost)) {
                    value = (String)value + "\n";
                }
                return value;
            }

            private boolean startsWithWhitespace(@NotNull CharSequence text, @NotNull TextRange range) {
                if (range.isEmpty()) {
                    return false;
                }
                char c = text.charAt(range.getStartOffset());
                return c == ' ' || c == '\t';
            }
        };
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (!StringUtil.endsWithChar((CharSequence)input, (char)'\n')) {
            throw new IllegalArgumentException("Should end with a line break");
        }
        int indent = this.locateIndent();
        if (indent == 0) {
            indent = YAMLUtil.getIndentToThisElement((PsiElement)this) + 2;
        }
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int currentLength = 0;
        boolean currentLineIsIndented = input.length() > 0 && input.charAt(0) == ' ';
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\n') {
                String replacement = i + 1 >= input.length() || YAMLGrammarCharUtil.isSpaceLike(input.charAt(i + 1)) || input.charAt(i + 1) == '\n' || currentLineIsIndented ? "\n" + indentString : "\n" + indentString;
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)replacement));
                currentLength = 0;
                currentLineIsIndented = i + 1 < input.length() && input.charAt(i + 1) == ' ';
                continue;
            }
            if (currentLength > 60 && input.charAt(i) == ' ' && i + 1 < input.length() && YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(i + 1))) {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n" + indentString)));
                currentLength = 0;
                continue;
            }
            ++currentLength;
        }
        return result;
    }

    @Override
    public String toString() {
        return "YAML scalar text";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitScalarText(this);
        } else {
            super.accept(visitor);
        }
    }
}

