/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLValueImpl;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

public abstract class YAMLScalarImpl
extends YAMLValueImpl
implements YAMLScalar {
    protected static final int MAX_SCALAR_LENGTH_PREDEFINED = 60;

    public YAMLScalarImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public abstract List<TextRange> getContentRanges();

    @NotNull
    public abstract YamlScalarTextEvaluator getTextEvaluator();

    protected List<Pair<TextRange, String>> getDecodeReplacements(@NotNull CharSequence input) {
        return Collections.emptyList();
    }

    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public final String getTextValue() {
        return this.getTextEvaluator().getTextValue(null);
    }

    @NotNull
    public final String getTextValue(@Nullable TextRange rangeInHost) {
        return this.getTextEvaluator().getTextValue(rangeInHost);
    }

    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 1 ? references[0] : null;
    }

    public PsiReference @NotNull [] getReferences() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new MyLiteralTextEscaper(this);
    }

    @NotNull
    static String processReplacements(@NotNull CharSequence input, @NotNull List<? extends Pair<TextRange, String>> replacements) throws IndexOutOfBoundsException {
        StringBuilder result = new StringBuilder();
        int currentOffset = 0;
        for (Pair<TextRange, String> pair : replacements) {
            result.append(input.subSequence(currentOffset, ((TextRange)pair.getFirst()).getStartOffset()));
            result.append((String)pair.getSecond());
            currentOffset = ((TextRange)pair.getFirst()).getEndOffset();
        }
        result.append(input.subSequence(currentOffset, input.length()));
        return result.toString();
    }

    protected static boolean isSurroundedByNoSpace(CharSequence text, int pos) {
        return !(pos - 1 >= 0 && YAMLGrammarCharUtil.isSpaceLike(text.charAt(pos - 1)) || pos + 1 < text.length() && YAMLGrammarCharUtil.isSpaceLike(text.charAt(pos + 1)));
    }

    @Nullable
    protected final ASTNode getFirstContentNode() {
        ASTNode node;
        for (node = this.getNode().getFirstChildNode(); node != null && (node.getElementType() == YAMLTokenTypes.TAG || YAMLElementTypes.BLANK_ELEMENTS.contains(node.getElementType())); node = node.getTreeNext()) {
        }
        return node;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitScalar(this);
        } else {
            super.accept(visitor);
        }
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                return StringUtil.shortenTextWithEllipsis((String)YAMLScalarImpl.this.getTextValue(), (int)20, (int)0, (boolean)true);
            }

            @NotNull
            public String getLocationString() {
                return YAMLScalarImpl.this.getContainingFile().getName();
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                return AllIcons.Nodes.Variable;
            }
        };
    }

    private static class MyLiteralTextEscaper
    extends LiteralTextEscaper<YAMLScalarImpl> {
        private String text;
        private List<TextRange> contentRanges;

        MyLiteralTextEscaper(YAMLScalarImpl scalar) {
            super((PsiLanguageInjectionHost)scalar);
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            this.text = ((YAMLScalarImpl)this.myHost).getText();
            this.contentRanges = ((YAMLScalarImpl)this.myHost).getContentRanges();
            boolean decoded = false;
            for (TextRange range : this.contentRanges) {
                TextRange intersection = range.intersection(rangeInsideHost);
                if (intersection == null) continue;
                decoded = true;
                String substring = intersection.substring(this.text);
                outChars.append(YAMLScalarImpl.processReplacements(substring, ((YAMLScalarImpl)this.myHost).getDecodeReplacements(substring)));
            }
            return decoded;
        }

        @NotNull
        public TextRange getRelevantTextRange() {
            if (this.contentRanges == null) {
                this.contentRanges = ((YAMLScalarImpl)this.myHost).getContentRanges();
            }
            if (this.contentRanges.isEmpty()) {
                return TextRange.EMPTY_RANGE;
            }
            return TextRange.create((int)this.contentRanges.get(0).getStartOffset(), (int)this.contentRanges.get(this.contentRanges.size() - 1).getEndOffset());
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            int currentOffsetInDecoded = 0;
            TextRange last = null;
            for (int i = 0; i < this.contentRanges.size(); ++i) {
                TextRange range = rangeInsideHost.intersection(this.contentRanges.get(i));
                if (range == null) continue;
                last = range;
                String curString = range.subSequence((CharSequence)this.text).toString();
                List<Pair<TextRange, String>> replacementsForThisLine = ((YAMLScalarImpl)this.myHost).getDecodeReplacements(curString);
                int encodedOffsetInCurrentLine = 0;
                for (Pair<TextRange, String> replacement : replacementsForThisLine) {
                    int deltaLength = ((TextRange)replacement.getFirst()).getStartOffset() - encodedOffsetInCurrentLine;
                    int currentOffsetBeforeReplacement = currentOffsetInDecoded + deltaLength;
                    if (currentOffsetBeforeReplacement > offsetInDecoded) {
                        return range.getStartOffset() + encodedOffsetInCurrentLine + (offsetInDecoded - currentOffsetInDecoded);
                    }
                    if (currentOffsetBeforeReplacement == offsetInDecoded && !((String)replacement.getSecond()).isEmpty()) {
                        return range.getStartOffset() + encodedOffsetInCurrentLine + (offsetInDecoded - currentOffsetInDecoded);
                    }
                    currentOffsetInDecoded += deltaLength + ((String)replacement.getSecond()).length();
                    encodedOffsetInCurrentLine += deltaLength + ((TextRange)replacement.getFirst()).getLength();
                }
                int deltaLength = curString.length() - encodedOffsetInCurrentLine;
                if (currentOffsetInDecoded + deltaLength > offsetInDecoded) {
                    return range.getStartOffset() + encodedOffsetInCurrentLine + (offsetInDecoded - currentOffsetInDecoded);
                }
                currentOffsetInDecoded += deltaLength;
            }
            return last != null ? last.getEndOffset() : -1;
        }

        public boolean isOneLine() {
            return !((YAMLScalarImpl)this.myHost).isMultiline();
        }
    }
}

