/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.navigation;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.impl.YAMLKeyValueImpl;

public class YAMLKeyNavigationItem
implements NavigationItem {
    @NotNull
    private final Navigatable myNavigatable;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myName;
    @NotNull
    private final VirtualFile myFile;
    private final int myPosition;

    YAMLKeyNavigationItem(@NotNull Project project, @NotNull String name, @NotNull VirtualFile file, int position) {
        this.myNavigatable = PsiNavigationSupport.getInstance().createNavigatable(project, file, position);
        this.myProject = project;
        this.myName = name;
        this.myFile = file;
        this.myPosition = position;
    }

    public void navigate(boolean requestFocus) {
        this.myNavigatable.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                return YAMLKeyNavigationItem.this.myName;
            }

            @NotNull
            public String getLocationString() {
                return YAMLKeyNavigationItem.this.myFile.toString();
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                return YAMLKeyValueImpl.YAML_KEY_ICON;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YAMLKeyNavigationItem item = (YAMLKeyNavigationItem)o;
        return this.myPosition == item.myPosition && this.myName.equals(item.myName) && this.myFile.equals(item.myFile);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myFile, this.myPosition);
    }
}

