/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

public class YamlArrayType
extends YamlMetaType {
    @NotNull
    private final YamlMetaType myElementType;

    public YamlArrayType(@NotNull YamlMetaType elementType) {
        super(elementType.getTypeName() + "[]");
        this.myElementType = elementType;
    }

    @Override
    public void validateValue(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
        if (!(value instanceof YAMLSequence)) {
            problemsHolder.registerProblem((PsiElement)value, YAMLBundle.message("YamlUnknownValuesInspectionBase.error.array.is.required", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NotNull
    public YamlMetaType getElementType() {
        return this.myElementType;
    }

    @Override
    @Nullable
    public Field findFeatureByName(@NotNull String name) {
        return null;
    }

    @Override
    @NotNull
    public List<String> computeMissingFields(@NotNull Set<String> existingFields) {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<Field> computeKeyCompletions(@Nullable YAMLMapping existingMapping) {
        return Collections.emptyList();
    }

    @Override
    public void buildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, @NotNull Field.Relation relation, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
    }
}

