/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlArrayType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

@ApiStatus.Internal
public abstract class YamlUnknownKeysInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        return new StructureChecker(holder, metaTypeProvider);
    }

    private static class StructureChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final YamlMetaTypeProvider myMetaTypeProvider;
        private final ProblemsHolder myProblemsHolder;

        StructureChecker(@NotNull ProblemsHolder problemsHolder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
            this.myProblemsHolder = problemsHolder;
            this.myMetaTypeProvider = metaTypeProvider;
        }

        @Override
        protected void visitYAMLKeyValue(@NotNull YAMLKeyValue keyValue) {
            if (keyValue.getKey() == null) {
                return;
            }
            if ("<<".equals(keyValue.getKey().getText())) {
                return;
            }
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getKeyValueMetaType(keyValue);
            if (meta == null) {
                YAMLMapping parent = keyValue.getParentMapping();
                if (parent != null) {
                    YamlMetaTypeProvider.MetaTypeProxy typeProxy = this.myMetaTypeProvider.getValueMetaType(parent);
                    if (typeProxy == null) {
                        return;
                    }
                    YamlMetaType parentMetaType = typeProxy.getMetaType();
                    if (parentMetaType instanceof YamlScalarType || parentMetaType instanceof YamlArrayType) {
                        return;
                    }
                }
                String msg = YAMLBundle.message("YamlUnknownKeysInspectionBase.unknown.key", keyValue.getKeyText());
                this.myProblemsHolder.registerProblem(keyValue.getKey(), msg, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
            }
        }
    }
}

