/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

@ApiStatus.Internal
public abstract class YamlMissingKeysInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        return new StructureChecker(holder, metaTypeProvider);
    }

    @Nullable
    private static PsiElement getMappingFromHighlightElement(PsiElement elementToHighlight) {
        if (elementToHighlight instanceof YAMLDocument) {
            return PsiTreeUtil.getChildOfAnyType((PsiElement)elementToHighlight, (Class[])new Class[]{YAMLMapping.class});
        }
        if (elementToHighlight.getParent() instanceof YAMLKeyValue) {
            return ((YAMLKeyValue)elementToHighlight.getParent()).getValue();
        }
        return PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, YAMLMapping.class);
    }

    @NotNull
    protected PsiElement getElementToHighlight(@NotNull YAMLMapping mapping) {
        PsiElement parent = mapping.getParent();
        if (parent instanceof YAMLDocument) {
            return parent;
        }
        if (parent instanceof YAMLSequenceItem) {
            PsiElement key = parent.getFirstChild();
            return key != null ? key : mapping;
        }
        if (parent instanceof YAMLKeyValue) {
            PsiElement key = ((YAMLKeyValue)parent).getKey();
            return key != null ? key : mapping;
        }
        return mapping;
    }

    @NotNull
    private static String composeKeyList(@NotNull Collection<String> missingKeys) {
        return String.join((CharSequence)", ", missingKeys);
    }

    @NotNull
    private static Collection<String> getMissingKeys(@NotNull YAMLMapping mapping, @NotNull YamlMetaType metaClass) {
        Set<String> existingKeys = mapping.getKeyValues().stream().map(it -> it.getKeyText().trim()).collect(Collectors.toSet());
        return metaClass.computeMissingFields(existingKeys);
    }

    protected class StructureChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final YamlMetaTypeProvider myMetaTypeProvider;
        private final ProblemsHolder myProblemsHolder;

        public StructureChecker(@NotNull ProblemsHolder problemsHolder, YamlMetaTypeProvider metaTypeProvider) {
            this.myProblemsHolder = problemsHolder;
            this.myMetaTypeProvider = metaTypeProvider;
        }

        @Override
        protected void visitYAMLMapping(@NotNull YAMLMapping mapping) {
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getMetaTypeProxy((PsiElement)mapping);
            if (meta == null) {
                return;
            }
            YamlMetaType metaType = meta.getMetaType();
            if (metaType instanceof YamlScalarType) {
                return;
            }
            Collection<String> missingKeys = YamlMissingKeysInspectionBase.getMissingKeys(mapping, metaType);
            if (!missingKeys.isEmpty()) {
                String msg = YAMLBundle.message("YamlMissingKeysInspectionBase.missing.keys", YamlMissingKeysInspectionBase.composeKeyList(missingKeys));
                this.myProblemsHolder.registerProblem(YamlMissingKeysInspectionBase.this.getElementToHighlight(mapping), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AddMissingKeysQuickFix(missingKeys)});
            }
        }
    }

    private static class AddMissingKeysQuickFix
    implements LocalQuickFix {
        @FileModifier.SafeFieldForPreview
        private final Collection<String> myMissingKeys;

        AddMissingKeysQuickFix(@NotNull Collection<String> missingKeys) {
            this.myMissingKeys = missingKeys;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return YAMLBundle.message("YamlMissingKeysInspectionBase.add.missing.keys.quickfix.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            YAMLElementGenerator elementGenerator = YAMLElementGenerator.getInstance(project);
            PsiElement mapping = YamlMissingKeysInspectionBase.getMappingFromHighlightElement(descriptor.getPsiElement());
            if (mapping == null) {
                return;
            }
            for (String missingKey : this.myMissingKeys) {
                mapping.add(elementGenerator.createEol());
                mapping.add(elementGenerator.createIndent(YAMLUtil.getIndentToThisElement(mapping)));
                mapping.add((PsiElement)elementGenerator.createYamlKeyValue(missingKey, ""));
            }
        }
    }
}

