/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.formatter.YAMLFormattingContext;
import org.jetbrains.yaml.formatter.YAMLFormattingModelBuilder;
import org.jetbrains.yaml.formatter.YamlInjectedBlockFactory;

class YAMLFormattingBlock
extends AbstractBlock {
    @NotNull
    private final YAMLFormattingContext myContext;
    @Nullable
    private final Indent myIndent;
    @Nullable
    private final Indent myNewChildIndent;
    private final boolean myIsIncomplete;
    @NotNull
    private final TextRange myTextRange;

    YAMLFormattingBlock(@NotNull YAMLFormattingContext context, @NotNull ASTNode node) {
        super(node, null, context.computeAlignment(node));
        this.myContext = context;
        this.myIndent = this.myContext.computeBlockIndent(this.myNode);
        this.myIsIncomplete = this.myContext.isIncomplete(this.myNode);
        this.myNewChildIndent = this.myContext.computeNewChildIndent(this.myNode);
        this.myTextRange = this.myNode.getTextRange();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        return this.myContext.computeSpacing((Block)this, child1, child2);
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isIncomplete() {
        return this.myIsIncomplete;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.myTextRange;
    }

    @Nullable
    protected Indent getChildIndent() {
        return this.myNewChildIndent;
    }

    protected List<Block> buildChildren() {
        return this.buildSubBlocks(this.myContext, this.myNode);
    }

    @NotNull
    private List<Block> buildSubBlocks(@NotNull YAMLFormattingContext context, @NotNull ASTNode node) {
        SmartList res = new SmartList();
        for (ASTNode subNode = node.getFirstChildNode(); subNode != null; subNode = subNode.getTreeNext()) {
            IElementType subNodeType = PsiUtilCore.getElementType((ASTNode)subNode);
            if (YAMLElementTypes.SPACE_ELEMENTS.contains(subNodeType)) continue;
            if (YAMLElementTypes.SCALAR_QUOTED_STRING == subNodeType) {
                res.addAll(this.buildSubBlocks(context, subNode));
                continue;
            }
            if (YAMLElementTypes.CONTAINERS.contains(subNodeType)) {
                res.addAll(YamlInjectedBlockFactory.substituteInjectedBlocks(context.mySettings, this.buildSubBlocks(context, subNode), subNode, this.getWrap(), context.computeAlignment(subNode)));
                continue;
            }
            res.add(YAMLFormattingModelBuilder.createBlock(context, subNode));
        }
        return res;
    }
}

