/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.impl.YAMLArrayImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;
import org.jetbrains.yaml.psi.impl.YAMLHashImpl;

public class YAMLFoldingBuilder
extends CustomFoldingBuilder {
    private static final int PLACEHOLDER_LEN = 20;

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        YAMLFoldingBuilder.collectDescriptors(root, descriptors);
    }

    private static void collectDescriptors(@NotNull PsiElement element, @NotNull List<? super FoldingDescriptor> descriptors) {
        TextRange nodeTextRange = element.getTextRange();
        if (nodeTextRange.getLength() < 2) {
            return;
        }
        if (element instanceof YAMLDocument) {
            if (PsiTreeUtil.findChildrenOfAnyType((PsiElement)element.getParent(), (Class[])new Class[]{YAMLDocument.class}).size() > 1) {
                descriptors.add((FoldingDescriptor)new FoldingDescriptor(element, nodeTextRange));
            }
        } else if (element instanceof YAMLScalar && ((YAMLScalar)element).isMultiline() || element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getValue() instanceof YAMLCompoundValue || element instanceof YAMLSequenceItem && ((YAMLSequenceItem)element).getValue() instanceof YAMLCompoundValue) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(element, nodeTextRange));
        }
        for (PsiElement child = element.getFirstChild(); child != null && (child = YAMLFoldingBuilder.foldComments(child, descriptors)) != null; child = child.getNextSibling()) {
            YAMLFoldingBuilder.collectDescriptors(child, descriptors);
        }
    }

    @Nullable
    private static PsiElement foldComments(PsiElement child, @NotNull List<? super FoldingDescriptor> descriptors) {
        PsiComment startComment = null;
        PsiComment endComment = null;
        int commentsCount = 0;
        while (child instanceof PsiComment) {
            ++commentsCount;
            if (startComment == null) {
                startComment = (PsiComment)child;
            }
            endComment = (PsiComment)child;
            child = YAMLFoldingBuilder.skipSpaceElementsUpToLine(child.getNextSibling());
        }
        if (commentsCount > 2) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor((PsiElement)startComment, TextRange.create((int)startComment.getTextRange().getStartOffset(), (int)endComment.getTextRange().getEndOffset())));
        }
        return child;
    }

    private static PsiElement skipSpaceElementsUpToLine(PsiElement element) {
        int eol = 0;
        while (element != null) {
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)element);
            if (YAMLElementTypes.EOL_ELEMENTS.contains(elementType)) {
                if (eol > 0) break;
                ++eol;
            }
            if (!YAMLElementTypes.SPACE_ELEMENTS.contains(elementType)) break;
            element = element.getNextSibling();
        }
        return element;
    }

    @Nullable
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        return YAMLFoldingBuilder.getPlaceholderText(SourceTreeToPsiMap.treeElementToPsi((ASTNode)node));
    }

    @NotNull
    private static String getPlaceholderText(@Nullable PsiElement psiElement) {
        if (psiElement instanceof YAMLDocument) {
            return "---";
        }
        if (psiElement instanceof PsiComment) {
            return "# ...";
        }
        if (psiElement instanceof YAMLScalar) {
            return YAMLFoldingBuilder.normalizePlaceHolderText(((YAMLScalar)psiElement).getTextValue());
        }
        if (psiElement instanceof YAMLSequence) {
            int size = ((YAMLSequence)psiElement).getItems().size();
            String placeholder = size + " " + StringUtil.pluralize((String)"item", (int)size);
            if (psiElement instanceof YAMLArrayImpl) {
                return "[" + placeholder + "]";
            }
            if (psiElement instanceof YAMLBlockSequenceImpl) {
                return "<" + placeholder + ">";
            }
        } else if (psiElement instanceof YAMLMapping) {
            int size = ((YAMLMapping)psiElement).getKeyValues().size();
            String placeholder = size + " " + StringUtil.pluralize((String)"key", (int)size);
            if (psiElement instanceof YAMLHashImpl) {
                return "{" + placeholder + "}";
            }
            if (psiElement instanceof YAMLBlockMappingImpl) {
                return "<" + placeholder + ">";
            }
        } else {
            if (psiElement instanceof YAMLKeyValue) {
                return YAMLFoldingBuilder.normalizePlaceHolderText(((YAMLKeyValue)psiElement).getKeyText()) + ": " + YAMLFoldingBuilder.getPlaceholderText((PsiElement)((YAMLKeyValue)psiElement).getValue());
            }
            if (psiElement instanceof YAMLSequenceItem) {
                return "- " + YAMLFoldingBuilder.getPlaceholderText((PsiElement)((YAMLSequenceItem)psiElement).getValue());
            }
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        return false;
    }

    private static String normalizePlaceHolderText(@Nullable String text) {
        if (text == null) {
            return null;
        }
        if (text.length() <= 20) {
            return text;
        }
        return StringUtil.trimMiddle((String)text, (int)20);
    }
}

