/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLPlainTextImpl;

final class YAMLWebReferenceContributor
extends PsiReferenceContributor {
    YAMLWebReferenceContributor() {
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(YAMLQuotedText.class), PlatformPatterns.psiElement(YAMLPlainTextImpl.class)}), new PsiReferenceProvider(){

            public boolean acceptsTarget(@NotNull PsiElement target) {
                return false;
            }

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (!(element instanceof YAMLScalar)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                if (!element.textContains(':')) {
                    return PsiReference.EMPTY_ARRAY;
                }
                YAMLScalar scalarElement = (YAMLScalar)element;
                LiteralTextEscaper escaper = scalarElement.createLiteralTextEscaper();
                if (!escaper.isOneLine()) {
                    return PsiReference.EMPTY_ARRAY;
                }
                TextRange textRange = escaper.getRelevantTextRange();
                if (textRange.isEmpty()) {
                    return PsiReference.EMPTY_ARRAY;
                }
                String textValue = scalarElement.getTextValue();
                if (GlobalPathReferenceProvider.isWebReferenceUrl((String)textValue)) {
                    return new PsiReference[]{new WebReference((PsiElement)scalarElement, textRange, textValue)};
                }
                return PsiReference.EMPTY_ARRAY;
            }
        }, -100.0);
    }
}

