/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.json.JsonSchemaSpellcheckerClient;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;

public class YAMLSpellcheckerStrategy
extends SpellcheckingStrategy {
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        IElementType type;
        ASTNode node = element.getNode();
        if (node != null && ((type = node.getElementType()) == YAMLTokenTypes.SCALAR_TEXT || type == YAMLTokenTypes.SCALAR_LIST || type == YAMLTokenTypes.TEXT || type == YAMLTokenTypes.SCALAR_KEY || type == YAMLTokenTypes.SCALAR_STRING || type == YAMLTokenTypes.SCALAR_DSTRING || type == YAMLTokenTypes.COMMENT)) {
            if (new JsonSchemaSpellcheckerClientForYaml(element).matchesNameFromSchema()) {
                return EMPTY_TOKENIZER;
            }
            return TEXT_TOKENIZER;
        }
        return super.getTokenizer(element);
    }

    private static class JsonSchemaSpellcheckerClientForYaml
    extends JsonSchemaSpellcheckerClient {
        @NotNull
        private final PsiElement element;

        protected JsonSchemaSpellcheckerClientForYaml(@NotNull PsiElement element) {
            this.element = element;
        }

        @NotNull
        protected PsiElement getElement() {
            return this.element;
        }

        @Nullable
        protected String getValue() {
            PsiElement parent = this.element.getParent();
            if (this.element.getNode().getElementType() == YAMLTokenTypes.SCALAR_KEY) {
                return ((YAMLKeyValue)parent).getKeyText();
            }
            if (parent instanceof YAMLScalar) {
                return ((YAMLScalar)parent).getTextValue();
            }
            return null;
        }

        protected boolean isXIntellijInjection(@NotNull JsonSchemaService service, @NotNull JsonSchemaObject rootSchema) {
            return false;
        }
    }
}

