/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLWordsScanner;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLScalarText;
import org.jetbrains.yaml.psi.YAMLSequence;

public class YAMLFindUsagesProvider
implements FindUsagesProvider {
    @Nullable
    public WordsScanner getWordsScanner() {
        return new YAMLWordsScanner();
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        return psiElement instanceof PsiNamedElement || psiElement instanceof YAMLScalar;
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        return "reference.dialogs.findUsages.other";
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element instanceof YAMLScalarText) {
            return YAMLBundle.message("find.usages.scalar", new Object[0]);
        }
        if (element instanceof YAMLSequence) {
            return YAMLBundle.message("find.usages.sequence", new Object[0]);
        }
        if (element instanceof YAMLMapping) {
            return YAMLBundle.message("find.usages.mapping", new Object[0]);
        }
        if (element instanceof YAMLKeyValue) {
            return YAMLBundle.message("find.usages.key.value", new Object[0]);
        }
        if (element instanceof YAMLDocument) {
            return YAMLBundle.message("find.usages.document", new Object[0]);
        }
        return "";
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element instanceof PsiNamedElement) {
            return StringUtil.notNullize((String)((PsiNamedElement)element).getName(), (String)YAMLBundle.message("find.usages.unnamed", new Object[0]));
        }
        if (element instanceof YAMLScalar) {
            return ((YAMLScalar)element).getTextValue();
        }
        return YAMLBundle.message("find.usages.unnamed", new Object[0]);
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        return this.getDescriptiveName(element);
    }
}

