/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.CommandSender;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.PacketStream;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.VMAction;
import com.jetbrains.jdi.VMListener;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

class VMState {
    private final VirtualMachineImpl vm;
    private final List<WeakReference<VMListener>> listeners = new ArrayList<WeakReference<VMListener>>();
    private boolean notifyingListeners = false;
    private final Set<Integer> pendingResumeCommands = Collections.synchronizedSet(new HashSet());
    private Cache cache = null;
    private static final Cache markerCache = new Cache();
    private final ReferenceQueue<VMListener> listenersReferenceQueue = new ReferenceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableCache() {
        VMState vMState = this;
        synchronized (vMState) {
            this.cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableCache() {
        VMState vMState = this;
        synchronized (vMState) {
            this.cache = markerCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache() {
        VMState vMState = this;
        synchronized (vMState) {
            if (this.cache == markerCache) {
                this.cache = new Cache();
            }
            return this.cache;
        }
    }

    VMState(VirtualMachineImpl vm) {
        this.vm = vm;
    }

    boolean isSuspended() {
        return this.cache != null;
    }

    void notifyCommandComplete(int id) {
        this.pendingResumeCommands.remove(id);
    }

    synchronized void freeze() {
        if (this.cache == null && this.pendingResumeCommands.isEmpty()) {
            this.processVMAction(new VMAction(this.vm, 1));
            this.enableCache();
        }
    }

    synchronized PacketStream thawCommand(CommandSender sender) {
        PacketStream stream = sender.send();
        this.pendingResumeCommands.add(stream.id());
        this.thaw();
        return stream;
    }

    void thaw() {
        this.thaw(null);
    }

    synchronized void thaw(ThreadReference resumingThread) {
        if (this.cache != null) {
            if ((this.vm.traceFlags & 0x10) != 0) {
                this.vm.printTrace("Clearing VM suspended cache");
            }
            this.disableCache();
        }
        this.processVMAction(new VMAction(this.vm, resumingThread, 2));
    }

    private synchronized void processVMAction(VMAction action) {
        if (!this.notifyingListeners) {
            this.notifyingListeners = true;
            Iterator<WeakReference<VMListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<VMListener> ref = iter.next();
                VMListener listener = (VMListener)ref.get();
                if (listener != null) {
                    boolean keep = true;
                    switch (action.id()) {
                        case 1: {
                            keep = listener.vmSuspended(action);
                            break;
                        }
                        case 2: {
                            keep = listener.vmNotSuspended(action);
                        }
                    }
                    if (keep) continue;
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
            this.notifyingListeners = false;
        }
    }

    synchronized void referenceTypeRemoved(ReferenceType type) {
        Iterator<WeakReference<VMListener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            VMListener listener = (VMListener)iter.next().get();
            if (listener != null) {
                listener.referenceTypeRemoved(type);
                continue;
            }
            iter.remove();
        }
    }

    private void removeUnreachableListeners() {
        boolean found = false;
        while (this.listenersReferenceQueue.poll() != null) {
            found = true;
        }
        if (found) {
            Iterator<WeakReference<VMListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                VMListener l = (VMListener)iter.next().get();
                if (l != null) continue;
                iter.remove();
            }
        }
    }

    synchronized void addListener(VMListener listener) {
        this.removeUnreachableListeners();
        this.listeners.add(new WeakReference<VMListener>(listener, this.listenersReferenceQueue));
    }

    synchronized boolean hasListener(VMListener listener) {
        return this.listeners.stream().anyMatch(ref -> listener.equals(ref.get()));
    }

    synchronized void removeListener(VMListener listener) {
        Iterator<WeakReference<VMListener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<VMListener> ref = iter.next();
            if (!listener.equals(ref.get())) continue;
            iter.remove();
            break;
        }
    }

    List<ThreadReference> allThreads() {
        List<ThreadReference> threads = null;
        try {
            Cache local = this.getCache();
            if (local != null) {
                threads = local.threads;
            }
            if (threads == null) {
                threads = Arrays.asList(JDWP.VirtualMachine.AllThreads.process((VirtualMachineImpl)this.vm).threads);
                if (local != null) {
                    local.threads = threads;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace("Caching all threads (count = " + threads.size() + ") while VM suspended");
                    }
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return threads;
    }

    CompletableFuture<List<ThreadReference>> allThreadsAsync() {
        Cache local = this.getCache();
        List<ThreadReference> threads = null;
        if (local != null) {
            threads = local.threads;
        }
        if (threads != null) {
            return CompletableFuture.completedFuture(threads);
        }
        return JDWP.VirtualMachine.AllThreads.processAsync(this.vm).thenApply(t -> {
            List<ThreadReferenceImpl> res = Arrays.asList(t.threads);
            Cache cache = this.getCache();
            if (cache != null) {
                cache.threads = res;
                if ((this.vm.traceFlags & 0x10) != 0) {
                    this.vm.printTrace("Caching all res (count = " + res.size() + ") while VM suspended");
                }
            }
            return res;
        });
    }

    List<ThreadGroupReference> topLevelThreadGroups() {
        List<ThreadGroupReference> groups = null;
        try {
            Cache local = this.getCache();
            if (local != null) {
                groups = local.groups;
            }
            if (groups == null) {
                groups = Arrays.asList(JDWP.VirtualMachine.TopLevelThreadGroups.process((VirtualMachineImpl)this.vm).groups);
                if (local != null) {
                    local.groups = groups;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace("Caching top level thread groups (count = " + groups.size() + ") while VM suspended");
                    }
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return groups;
    }

    private static class Cache {
        List<ThreadGroupReference> groups = null;
        List<ThreadReference> threads = null;

        private Cache() {
        }
    }
}

