/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ReferenceTypeImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class SDE {
    private static final int INIT_SIZE_FILE = 3;
    private static final int INIT_SIZE_LINE = 100;
    private static final int INIT_SIZE_STRATUM = 3;
    static final String BASE_STRATUM_NAME = "Java";
    static final String NullString = null;
    private FileTableRecord[] fileTable = null;
    private LineTableRecord[] lineTable = null;
    private StratumTableRecord[] stratumTable = null;
    private int fileIndex = 0;
    private int lineIndex = 0;
    private int stratumIndex = 0;
    private int currentFileId = 0;
    private int defaultStratumIndex = -1;
    private int baseStratumIndex = -2;
    private int sdePos = 0;
    final String sourceDebugExtension;
    String jplsFilename = null;
    String defaultStratumId = null;
    boolean isValid = false;

    SDE(String sourceDebugExtension) {
        this.sourceDebugExtension = sourceDebugExtension;
        this.decode();
    }

    SDE() {
        this.sourceDebugExtension = null;
        this.createProxyForAbsentSDE();
    }

    char sdePeek() {
        if (this.sdePos >= this.sourceDebugExtension.length()) {
            this.syntax();
        }
        return this.sourceDebugExtension.charAt(this.sdePos);
    }

    char sdeRead() {
        if (this.sdePos >= this.sourceDebugExtension.length()) {
            this.syntax();
        }
        return this.sourceDebugExtension.charAt(this.sdePos++);
    }

    void sdeAdvance() {
        ++this.sdePos;
    }

    void syntax() {
        throw new InternalError("bad SourceDebugExtension syntax - position " + this.sdePos);
    }

    void syntax(String msg) {
        throw new InternalError("bad SourceDebugExtension syntax: " + msg);
    }

    void assureLineTableSize() {
        int len;
        int n = len = this.lineTable == null ? 0 : this.lineTable.length;
        if (this.lineIndex >= len) {
            int i;
            int newLen = len == 0 ? 100 : len * 2;
            LineTableRecord[] newTable = new LineTableRecord[newLen];
            for (i = 0; i < len; ++i) {
                newTable[i] = this.lineTable[i];
            }
            while (i < newLen) {
                newTable[i] = new LineTableRecord();
                ++i;
            }
            this.lineTable = newTable;
        }
    }

    void assureFileTableSize() {
        int len;
        int n = len = this.fileTable == null ? 0 : this.fileTable.length;
        if (this.fileIndex >= len) {
            int i;
            int newLen = len == 0 ? 3 : len * 2;
            FileTableRecord[] newTable = new FileTableRecord[newLen];
            for (i = 0; i < len; ++i) {
                newTable[i] = this.fileTable[i];
            }
            while (i < newLen) {
                newTable[i] = new FileTableRecord();
                ++i;
            }
            this.fileTable = newTable;
        }
    }

    void assureStratumTableSize() {
        int len;
        int n = len = this.stratumTable == null ? 0 : this.stratumTable.length;
        if (this.stratumIndex >= len) {
            int i;
            int newLen = len == 0 ? 3 : len * 2;
            StratumTableRecord[] newTable = new StratumTableRecord[newLen];
            for (i = 0; i < len; ++i) {
                newTable[i] = this.stratumTable[i];
            }
            while (i < newLen) {
                newTable[i] = new StratumTableRecord();
                ++i;
            }
            this.stratumTable = newTable;
        }
    }

    String readLine() {
        char ch;
        StringBuilder sb = new StringBuilder();
        this.ignoreWhite();
        while ((ch = this.sdeRead()) != '\n' && ch != '\r') {
            sb.append(ch);
        }
        if (ch == '\r' && this.sdePeek() == '\n') {
            this.sdeRead();
        }
        this.ignoreWhite();
        return sb.toString();
    }

    private int defaultStratumTableIndex() {
        if (this.defaultStratumIndex == -1 && this.defaultStratumId != null) {
            this.defaultStratumIndex = this.stratumTableIndex(this.defaultStratumId);
        }
        return this.defaultStratumIndex;
    }

    int stratumTableIndex(String stratumId) {
        if (stratumId == null) {
            return this.defaultStratumTableIndex();
        }
        for (int i = 0; i < this.stratumIndex - 1; ++i) {
            if (!this.stratumTable[i].id.equals(stratumId)) continue;
            return i;
        }
        return this.defaultStratumTableIndex();
    }

    Stratum stratum(String stratumID) {
        int sti = this.stratumTableIndex(stratumID);
        return new Stratum(sti);
    }

    List<String> availableStrata() {
        ArrayList<String> strata = new ArrayList<String>();
        for (int i = 0; i < this.stratumIndex - 1; ++i) {
            StratumTableRecord rec = this.stratumTable[i];
            strata.add(rec.id);
        }
        return strata;
    }

    void ignoreWhite() {
        char ch;
        while ((ch = this.sdePeek()) == ' ' || ch == '\t') {
            this.sdeAdvance();
        }
    }

    void ignoreLine() {
        char ch;
        while ((ch = this.sdeRead()) != '\n' && ch != '\r') {
        }
        if (ch == '\r' && this.sdePeek() == '\n') {
            this.sdeAdvance();
        }
        this.ignoreWhite();
    }

    int readNumber() {
        char ch;
        int value = 0;
        this.ignoreWhite();
        while ((ch = this.sdePeek()) >= '0' && ch <= '9') {
            this.sdeAdvance();
            value = value * 10 + ch - 48;
        }
        this.ignoreWhite();
        return value;
    }

    void storeFile(int fileId, String sourceName, String sourcePath) {
        this.assureFileTableSize();
        this.fileTable[this.fileIndex].fileId = fileId;
        this.fileTable[this.fileIndex].sourceName = sourceName;
        this.fileTable[this.fileIndex].sourcePath = sourcePath;
        ++this.fileIndex;
    }

    void fileLine() {
        boolean hasAbsolute = false;
        String sourcePath = null;
        if (this.sdePeek() == '+') {
            this.sdeAdvance();
            hasAbsolute = true;
        }
        int fileId = this.readNumber();
        String sourceName = this.readLine();
        if (hasAbsolute) {
            sourcePath = this.readLine();
        }
        this.storeFile(fileId, sourceName, sourcePath);
    }

    void storeLine(int jplsStart, int jplsEnd, int jplsLineInc, int njplsStart, int njplsEnd, int fileId) {
        this.assureLineTableSize();
        this.lineTable[this.lineIndex].jplsStart = jplsStart;
        this.lineTable[this.lineIndex].jplsEnd = jplsEnd;
        this.lineTable[this.lineIndex].jplsLineInc = jplsLineInc;
        this.lineTable[this.lineIndex].njplsStart = njplsStart;
        this.lineTable[this.lineIndex].njplsEnd = njplsEnd;
        this.lineTable[this.lineIndex].fileId = fileId;
        ++this.lineIndex;
    }

    void lineLine() {
        int lineCount = 1;
        int lineIncrement = 1;
        int njplsStart = this.readNumber();
        if (this.sdePeek() == '#') {
            this.sdeAdvance();
            this.currentFileId = this.readNumber();
        }
        if (this.sdePeek() == ',') {
            this.sdeAdvance();
            lineCount = this.readNumber();
        }
        if (this.sdeRead() != ':') {
            this.syntax();
        }
        int jplsStart = this.readNumber();
        if (this.sdePeek() == ',') {
            this.sdeAdvance();
            lineIncrement = this.readNumber();
        }
        this.ignoreLine();
        this.storeLine(jplsStart, jplsStart + lineCount * lineIncrement - 1, lineIncrement, njplsStart, njplsStart + lineCount - 1, this.currentFileId);
    }

    void storeStratum(String stratumId) {
        if (this.stratumIndex > 0 && this.stratumTable[this.stratumIndex - 1].fileIndex == this.fileIndex && this.stratumTable[this.stratumIndex - 1].lineIndex == this.lineIndex) {
            --this.stratumIndex;
        }
        this.assureStratumTableSize();
        this.stratumTable[this.stratumIndex].id = stratumId;
        this.stratumTable[this.stratumIndex].fileIndex = this.fileIndex;
        this.stratumTable[this.stratumIndex].lineIndex = this.lineIndex;
        ++this.stratumIndex;
        this.currentFileId = 0;
    }

    void stratumSection() {
        this.storeStratum(this.readLine());
    }

    void fileSection() {
        this.ignoreLine();
        while (this.sdePeek() != '*') {
            this.fileLine();
        }
    }

    void lineSection() {
        this.ignoreLine();
        while (this.sdePeek() != '*') {
            this.lineLine();
        }
    }

    void ignoreSection() {
        this.ignoreLine();
        while (this.sdePeek() != '*') {
            this.ignoreLine();
        }
    }

    void createJavaStratum() {
        this.baseStratumIndex = this.stratumIndex;
        this.storeStratum(BASE_STRATUM_NAME);
        this.storeFile(1, this.jplsFilename, NullString);
        this.storeLine(1, 65536, 1, 1, 65536, 1);
        this.storeStratum("Aux");
    }

    void decode() {
        if (this.sourceDebugExtension.length() < 4 || this.sdeRead() != 'S' || this.sdeRead() != 'M' || this.sdeRead() != 'A' || this.sdeRead() != 'P') {
            return;
        }
        this.ignoreLine();
        this.jplsFilename = this.readLine();
        this.defaultStratumId = this.readLine();
        this.createJavaStratum();
        block6: while (true) {
            if (this.sdeRead() != '*') {
                this.syntax();
            }
            switch (this.sdeRead()) {
                case 'S': {
                    this.stratumSection();
                    continue block6;
                }
                case 'F': {
                    this.fileSection();
                    continue block6;
                }
                case 'L': {
                    this.lineSection();
                    continue block6;
                }
                case 'E': {
                    this.storeStratum("*terminator*");
                    this.isValid = true;
                    return;
                }
            }
            this.ignoreSection();
        }
    }

    void createProxyForAbsentSDE() {
        this.jplsFilename = null;
        this.defaultStratumId = BASE_STRATUM_NAME;
        this.defaultStratumIndex = this.stratumIndex;
        this.createJavaStratum();
        this.storeStratum("*terminator*");
    }

    private int stiLineTableIndex(int sti, int jplsLine) {
        int lineIndexStart = this.stratumTable[sti].lineIndex;
        int lineIndexEnd = this.stratumTable[sti + 1].lineIndex;
        for (int i = lineIndexStart; i < lineIndexEnd; ++i) {
            if (jplsLine < this.lineTable[i].jplsStart || jplsLine > this.lineTable[i].jplsEnd) continue;
            return i;
        }
        return -1;
    }

    private int stiLineNumber(int sti, int lti, int jplsLine) {
        return this.lineTable[lti].njplsStart + (jplsLine - this.lineTable[lti].jplsStart) / this.lineTable[lti].jplsLineInc;
    }

    private int fileTableIndex(int sti, int fileId) {
        int fileIndexStart = this.stratumTable[sti].fileIndex;
        int fileIndexEnd = this.stratumTable[sti + 1].fileIndex;
        for (int i = fileIndexStart; i < fileIndexEnd; ++i) {
            if (this.fileTable[i].fileId != fileId) continue;
            return i;
        }
        return -1;
    }

    private int stiFileTableIndex(int sti, int lti) {
        return this.fileTableIndex(sti, this.lineTable[lti].fileId);
    }

    boolean isValid() {
        return this.isValid;
    }

    private static class FileTableRecord {
        int fileId;
        String sourceName;
        String sourcePath;
        boolean isConverted = false;

        private FileTableRecord() {
        }

        String getSourcePath(ReferenceTypeImpl refType) {
            if (!this.isConverted) {
                if (this.sourcePath == null) {
                    this.sourcePath = refType.baseSourceDir() + this.sourceName;
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < this.sourcePath.length(); ++i) {
                        char ch = this.sourcePath.charAt(i);
                        if (ch == '/') {
                            sb.append(File.separatorChar);
                            continue;
                        }
                        sb.append(ch);
                    }
                    this.sourcePath = sb.toString();
                }
                this.isConverted = true;
            }
            return this.sourcePath;
        }
    }

    private static class LineTableRecord {
        int jplsStart;
        int jplsEnd;
        int jplsLineInc;
        int njplsStart;
        int njplsEnd;
        int fileId;

        private LineTableRecord() {
        }
    }

    private static class StratumTableRecord {
        String id;
        int fileIndex;
        int lineIndex;

        private StratumTableRecord() {
        }
    }

    class Stratum {
        private final int sti;

        private Stratum(int sti) {
            this.sti = sti;
        }

        String id() {
            return SDE.this.stratumTable[this.sti].id;
        }

        boolean isJava() {
            return this.sti == SDE.this.baseStratumIndex;
        }

        List<String> sourceNames(ReferenceTypeImpl refType) {
            int fileIndexStart = SDE.this.stratumTable[this.sti].fileIndex;
            int fileIndexEnd = SDE.this.stratumTable[this.sti + 1].fileIndex;
            ArrayList<String> result = new ArrayList<String>(fileIndexEnd - fileIndexStart);
            for (int i = fileIndexStart; i < fileIndexEnd; ++i) {
                result.add(SDE.this.fileTable[i].sourceName);
            }
            return result;
        }

        List<String> sourcePaths(ReferenceTypeImpl refType) {
            int fileIndexStart = SDE.this.stratumTable[this.sti].fileIndex;
            int fileIndexEnd = SDE.this.stratumTable[this.sti + 1].fileIndex;
            ArrayList<String> result = new ArrayList<String>(fileIndexEnd - fileIndexStart);
            for (int i = fileIndexStart; i < fileIndexEnd; ++i) {
                result.add(SDE.this.fileTable[i].getSourcePath(refType));
            }
            return result;
        }

        LineStratum lineStratum(ReferenceTypeImpl refType, int jplsLine) {
            int lti = SDE.this.stiLineTableIndex(this.sti, jplsLine);
            if (lti < 0) {
                return null;
            }
            return new LineStratum(this.sti, lti, refType, jplsLine);
        }
    }

    class LineStratum {
        private final int sti;
        private final int lti;
        private final ReferenceTypeImpl refType;
        private final int jplsLine;
        private String sourceName = null;
        private String sourcePath = null;

        private LineStratum(int sti, int lti, ReferenceTypeImpl refType, int jplsLine) {
            this.sti = sti;
            this.lti = lti;
            this.refType = refType;
            this.jplsLine = jplsLine;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LineStratum) {
                LineStratum other = (LineStratum)obj;
                return this.lti == other.lti && this.sti == other.sti && this.lineNumber() == other.lineNumber() && this.refType.equals(other.refType);
            }
            return false;
        }

        public int hashCode() {
            return this.lineNumber() * 17 ^ this.refType.hashCode();
        }

        int lineNumber() {
            return SDE.this.stiLineNumber(this.sti, this.lti, this.jplsLine);
        }

        void getSourceInfo() {
            if (this.sourceName != null) {
                return;
            }
            int fti = SDE.this.stiFileTableIndex(this.sti, this.lti);
            if (fti == -1) {
                throw new InternalError("Bad SourceDebugExtension, no matching source id " + SDE.this.lineTable[this.lti].fileId + " jplsLine: " + this.jplsLine);
            }
            FileTableRecord ftr = SDE.this.fileTable[fti];
            this.sourceName = ftr.sourceName;
            this.sourcePath = ftr.getSourcePath(this.refType);
        }

        String sourceName() {
            this.getSourceInfo();
            return this.sourceName;
        }

        String sourcePath() {
            this.getSourceInfo();
            return this.sourcePath;
        }
    }
}

