/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;

public class HgReferenceValidator
implements InputValidatorEx {
    @Nls
    protected String myErrorText;
    private static final HgReferenceValidator INSTANCE = new HgReferenceValidator();
    private static final Pattern DIGITS_ILLEGAL = Pattern.compile("[0-9]*");
    private static final Pattern ILLEGAL = Pattern.compile("[:]");

    public static HgReferenceValidator getInstance() {
        return INSTANCE;
    }

    protected HgReferenceValidator() {
    }

    public boolean checkInput(String inputString) {
        if (StringUtil.isEmptyOrSpaces((String)inputString)) {
            return false;
        }
        if (this.containsIllegalSymbols(inputString)) {
            return false;
        }
        return !this.isReservedWord(inputString) && !this.onlyDigits(inputString) && !this.hasConflictsWithAnotherNames(inputString);
    }

    protected boolean containsIllegalSymbols(@Nullable String inputString) {
        if (inputString != null && ILLEGAL.matcher(inputString).find()) {
            this.myErrorText = HgBundle.message("hg4idea.validation.name.no.colons", new Object[0]);
            return true;
        }
        return false;
    }

    private boolean onlyDigits(@Nullable String inputString) {
        if (inputString != null && DIGITS_ILLEGAL.matcher(inputString).matches()) {
            this.myErrorText = HgBundle.message("hg4idea.validation.name.invalid", new Object[0]);
            return true;
        }
        return false;
    }

    public boolean canClose(@Nullable String name) {
        return this.checkInput(name);
    }

    private boolean isReservedWord(@Nullable String name) {
        this.myErrorText = "tip".equals(name) ? HgBundle.message("hg4idea.validation.name.reserved", name) : null;
        return this.myErrorText != null;
    }

    protected boolean hasConflictsWithAnotherNames(@Nullable String name) {
        return false;
    }

    @Nullable
    public String getErrorText(@Nullable String inputString) {
        return this.myErrorText;
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String branchName) {
        if (this.onlyDigits(branchName)) {
            return branchName + "_";
        }
        return branchName.replaceAll(ILLEGAL.pattern(), "_").replaceAll("\"", "");
    }
}

