/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.status.HgChangesetStatus;
import org.zmlx.hg4idea.status.HgRemoteStatusUpdater;
import org.zmlx.hg4idea.status.ui.HgWidgetUpdater;

final class HgIncomingOutgoingWidget
extends EditorBasedWidget
implements StatusBarWidget.IconPresentation,
StatusBarWidget.Multiframe {
    private static final String INCOMING_WIDGET_ID = "InHgIncomingOutgoingWidget";
    private static final String OUTGOING_WIDGET_ID = "OutHgIncomingOutgoingWidget";
    @NotNull
    private final HgVcs myVcs;
    private final boolean myIsIncoming;
    @NotNull
    private final Icon myEnabledIcon;
    @NotNull
    private final Icon myDisabledIcon;
    private volatile @NlsContexts.Tooltip String myTooltip = "";
    private Icon myCurrentIcon;

    HgIncomingOutgoingWidget(@NotNull HgVcs vcs, boolean isIncoming) {
        super(vcs.getProject());
        this.myIsIncoming = isIncoming;
        this.myVcs = vcs;
        this.myEnabledIcon = this.myIsIncoming ? AllIcons.Ide.IncomingChangesOn : AllIcons.Ide.OutgoingChangesOn;
        this.myCurrentIcon = this.myDisabledIcon = IconLoader.getDisabledIcon((Icon)this.myEnabledIcon);
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, () -> this.updateLater());
        busConnection.subscribe(HgVcs.STATUS_TOPIC, (project, root) -> this.updateLater());
        busConnection.subscribe(HgVcs.REMOTE_TOPIC, (project, root) -> this.updateLater());
        busConnection.subscribe(HgVcs.INCOMING_OUTGOING_CHECK_TOPIC, (Object)new HgWidgetUpdater(){

            @Override
            public void update() {
                HgIncomingOutgoingWidget.this.updateLater();
            }
        });
        this.updateLater();
    }

    public StatusBarWidget copy() {
        return new HgIncomingOutgoingWidget(this.myVcs, this.myIsIncoming);
    }

    @NotNull
    public String ID() {
        return this.myIsIncoming ? INCOMING_WIDGET_ID : OUTGOING_WIDGET_ID;
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        this.updateLater();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        this.updateLater();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        this.updateLater();
    }

    public String getTooltipText() {
        return this.myTooltip;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return mouseEvent -> this.updateLater();
    }

    public void updateLater() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            HgRemoteStatusUpdater statusUpdater = this.myVcs.getRemoteStatusUpdater();
            if (statusUpdater == null) {
                return;
            }
            HgChangesetStatus status = statusUpdater.getStatus(this.myIsIncoming);
            boolean changesAvailable = status.getNumChanges() > 0;
            this.myCurrentIcon = changesAvailable ? this.myEnabledIcon : this.myDisabledIcon;
            Object object = this.myTooltip = changesAvailable ? "\n" + status.getToolTip() : HgBundle.message("no.changes.available", new Object[0]);
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        });
    }

    @NotNull
    public Icon getIcon() {
        return this.myCurrentIcon;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            super.dispose();
        }
    }

    private static abstract class MyWidgetFactory
    implements StatusBarWidgetFactory {
        private final boolean myIsIncoming;

        protected MyWidgetFactory(boolean isIncoming) {
            this.myIsIncoming = isIncoming;
        }

        public boolean isAvailable(@NotNull Project project) {
            return HgRemoteStatusUpdater.isCheckingEnabled(project);
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            HgVcs hgVcs = Objects.requireNonNull(HgVcs.getInstance(project));
            return new HgIncomingOutgoingWidget(hgVcs, this.myIsIncoming);
        }

        public void disposeWidget(@NotNull StatusBarWidget widget) {
            Disposer.dispose((Disposable)widget);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            return true;
        }

        @NotNull
        public String getId() {
            return this.myIsIncoming ? HgIncomingOutgoingWidget.INCOMING_WIDGET_ID : HgIncomingOutgoingWidget.OUTGOING_WIDGET_ID;
        }

        @NotNull
        public String getDisplayName() {
            return this.myIsIncoming ? HgBundle.message("hg4idea.status.bar.incoming.widget.name", new Object[0]) : HgBundle.message("hg4idea.status.bar.outgoing.widget.name", new Object[0]);
        }
    }

    public static class OutgoingFactory
    extends MyWidgetFactory {
        public OutgoingFactory() {
            super(false);
        }
    }

    public static class IncomingFactory
    extends MyWidgetFactory {
        public IncomingFactory() {
            super(true);
        }
    }

    public static class Listener
    implements VcsRepositoryMappingListener,
    HgWidgetUpdater {
        private final Project myProject;

        public Listener(@NotNull Project project) {
            this.myProject = project;
        }

        public void mappingChanged() {
            this.updateVisibility();
        }

        @Override
        public void updateVisibility() {
            StatusBarWidgetsManager widgetsManager = (StatusBarWidgetsManager)this.myProject.getService(StatusBarWidgetsManager.class);
            widgetsManager.updateWidget(IncomingFactory.class);
            widgetsManager.updateWidget(OutgoingFactory.class);
        }
    }
}

