/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.vcs.log.Hash;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;

public class HgRepoInfo {
    @NotNull
    private final String myCurrentBranch;
    @Nullable
    private final String myTipRevision;
    @Nullable
    private final String myCurrentRevision;
    @NotNull
    private final Repository.State myState;
    @Nullable
    private final String myCurrentBookmark;
    @NotNull
    private final Map<String, LinkedHashSet<Hash>> myBranches;
    @NotNull
    private final Set<HgNameWithHashInfo> myBookmarks;
    @NotNull
    private final Set<HgNameWithHashInfo> myTags;
    @NotNull
    private final Set<HgNameWithHashInfo> myLocalTags;
    @NotNull
    private final Set<HgNameWithHashInfo> mySubrepos;
    @NotNull
    private final List<HgNameWithHashInfo> myMQApplied;
    @NotNull
    private final List<String> myMqNames;

    public HgRepoInfo(@NotNull String currentBranch, @Nullable String currentRevision, @Nullable String currentTipRevision, @NotNull Repository.State state, @NotNull Map<String, LinkedHashSet<Hash>> branches, @NotNull Collection<HgNameWithHashInfo> bookmarks, @Nullable String currentBookmark, @NotNull Collection<HgNameWithHashInfo> tags, @NotNull Collection<HgNameWithHashInfo> localTags, @NotNull Collection<HgNameWithHashInfo> subrepos, @NotNull List<HgNameWithHashInfo> mqApplied, @NotNull List<String> mqNames) {
        this.myCurrentBranch = currentBranch;
        this.myCurrentRevision = currentRevision;
        this.myTipRevision = currentTipRevision;
        this.myState = state;
        this.myBranches = branches;
        this.myBookmarks = new LinkedHashSet<HgNameWithHashInfo>(bookmarks);
        this.myCurrentBookmark = currentBookmark;
        this.myTags = new LinkedHashSet<HgNameWithHashInfo>(tags);
        this.myLocalTags = new LinkedHashSet<HgNameWithHashInfo>(localTags);
        this.mySubrepos = new HashSet<HgNameWithHashInfo>(subrepos);
        this.myMQApplied = mqApplied;
        this.myMqNames = mqNames;
    }

    @NotNull
    public String getCurrentBranch() {
        return this.myCurrentBranch;
    }

    @NotNull
    public Map<String, LinkedHashSet<Hash>> getBranches() {
        return this.myBranches;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getBookmarks() {
        return this.myBookmarks;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getTags() {
        return this.myTags;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getLocalTags() {
        return this.myLocalTags;
    }

    @Nullable
    public String getTipRevision() {
        return this.myTipRevision;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    @Nullable
    public String getCurrentBookmark() {
        return this.myCurrentBookmark;
    }

    @NotNull
    public Repository.State getState() {
        return this.myState;
    }

    @NotNull
    public List<HgNameWithHashInfo> getMQApplied() {
        return this.myMQApplied;
    }

    public List<String> getMqPatchNames() {
        return this.myMqNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgRepoInfo info = (HgRepoInfo)o;
        if (this.myState != info.myState) {
            return false;
        }
        if (this.myTipRevision != null ? !this.myTipRevision.equals(info.myTipRevision) : info.myTipRevision != null) {
            return false;
        }
        if (this.myCurrentRevision != null ? !this.myCurrentRevision.equals(info.myCurrentRevision) : info.myCurrentRevision != null) {
            return false;
        }
        if (!this.myCurrentBranch.equals(info.myCurrentBranch)) {
            return false;
        }
        if (this.myCurrentBookmark != null ? !this.myCurrentBookmark.equals(info.myCurrentBookmark) : info.myCurrentBookmark != null) {
            return false;
        }
        if (!this.myBranches.equals(info.myBranches)) {
            return false;
        }
        if (!this.myBookmarks.equals(info.myBookmarks)) {
            return false;
        }
        if (!this.myTags.equals(info.myTags)) {
            return false;
        }
        if (!this.myLocalTags.equals(info.myLocalTags)) {
            return false;
        }
        if (!this.mySubrepos.equals(info.mySubrepos)) {
            return false;
        }
        if (!this.myMQApplied.equals(info.myMQApplied)) {
            return false;
        }
        return this.myMqNames.equals(info.myMqNames);
    }

    public int hashCode() {
        return Objects.hash(this.myCurrentBranch, this.myCurrentRevision, this.myTipRevision, this.myCurrentBookmark, this.myState, this.myBranches, this.myBookmarks, this.myTags, this.myLocalTags, this.mySubrepos, this.myMQApplied, this.myMqNames);
    }

    @NonNls
    @NotNull
    public String toString() {
        return String.format("HgRepository{myCurrentBranch=%s, myCurrentRevision='%s', myState=%s}", this.myCurrentBranch, this.myCurrentRevision, this.myState);
    }

    public boolean hasSubrepos() {
        return !this.mySubrepos.isEmpty();
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getSubrepos() {
        return this.mySubrepos;
    }
}

