/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.commit;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.AmendCommitHandler;
import com.intellij.vcs.commit.AmendCommitModeListener;
import com.intellij.vcs.commit.EditedCommitDetails;
import com.intellij.vcs.commit.LocalChangesCommitterKt;
import com.intellij.vcs.commit.ToggleAmendCommitOption;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgAddCommand;
import org.zmlx.hg4idea.command.HgCommitCommand;
import org.zmlx.hg4idea.command.HgCommitTypeCommand;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.command.mq.HgQNewCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.provider.HgCurrentBinaryContentRevision;
import org.zmlx.hg4idea.provider.commit.HgAmendCommitService;
import org.zmlx.hg4idea.provider.commit.HgCommitAndPushExecutorKt;
import org.zmlx.hg4idea.provider.commit.HgCommitOptionsKt;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCheckinEnvironment
implements CheckinEnvironment,
AmendCommitAware {
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final Project myProject;

    public HgCheckinEnvironment(@NotNull HgVcs vcs) {
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
    }

    @Nullable
    public RefreshableOnComponent createCommitOptions(@NotNull CheckinProjectPanel commitPanel, @NotNull CommitContext commitContext) {
        Set repos = ContainerUtil.map2SetNotNull((Collection)commitPanel.getRoots(), arg_0 -> ((HgRepositoryManager)HgUtil.getRepositoryManager(this.myProject)).getRepositoryForFileQuick(arg_0));
        boolean hasSubrepos = ContainerUtil.exists((Iterable)repos, HgRepository::hasSubrepos);
        boolean showAmendOption = ToggleAmendCommitOption.isAmendCommitOptionSupported((CheckinProjectPanel)commitPanel, (AmendCommitAware)this);
        if (!hasSubrepos && !showAmendOption) {
            return null;
        }
        return new HgCommitAdditionalComponent(commitPanel, commitContext, hasSubrepos, showAmendOption);
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return HgBundle.message("hg4idea.commit", new Object[0]);
    }

    public boolean isAmendCommitSupported() {
        return this.getAmendService().isAmendCommitSupported();
    }

    @Nullable
    public String getLastCommitMessage(@NotNull VirtualFile root) {
        return this.getAmendService().getLastCommitMessage(root);
    }

    @NotNull
    public CancellablePromise<EditedCommitDetails> getAmendCommitDetails(@NotNull VirtualFile root) {
        return this.getAmendService().getAmendCommitDetails(root);
    }

    @NotNull
    private HgAmendCommitService getAmendService() {
        return (HgAmendCommitService)((Object)this.myProject.getService(HgAmendCommitService.class));
    }

    @NotNull
    public List<VcsException> commit(@NotNull List<? extends Change> changes, @NotNull String commitMessage, @NotNull CommitContext commitContext, @NotNull Set<? super String> feedback) {
        LinkedList<VcsException> exceptions = new LinkedList<VcsException>();
        Map<HgRepository, Set<HgFile>> repositoriesMap = this.getFilesByRepository(changes);
        this.addRepositoriesWithoutChanges(repositoriesMap, commitContext);
        boolean isAmend = AbstractCommitWorkflowKt.isAmendCommitMode((CommitContext)commitContext);
        for (Map.Entry<HgRepository, Set<HgFile>> entry : repositoriesMap.entrySet()) {
            HgCommitTypeCommand command;
            HgRepository repo = entry.getKey();
            Set<HgFile> selectedFiles = entry.getValue();
            boolean isCloseBranch = HgCommitOptionsKt.isCloseBranch(commitContext);
            boolean isCommitSubrepositories = HgCommitOptionsKt.isCommitSubrepositories(commitContext);
            HgCommitTypeCommand hgCommitTypeCommand = HgCommitOptionsKt.isMqNewPatch(commitContext) ? new HgQNewCommand(this.myProject, repo, commitMessage, isAmend) : (command = new HgCommitCommand(this.myProject, repo, commitMessage, isAmend, isCloseBranch, isCommitSubrepositories && !selectedFiles.isEmpty()));
            if (this.isMergeCommit(repo.getRoot())) {
                boolean partial;
                Set<HgFile> changedFilesNotInCommit = this.getChangedFilesNotInCommit(repo.getRoot(), selectedFiles);
                boolean bl = partial = !changedFilesNotInCommit.isEmpty();
                if (partial) {
                    StringBuilder filesNotIncludedString = new StringBuilder();
                    for (HgFile hgFile : changedFilesNotInCommit) {
                        filesNotIncludedString.append("<li>");
                        filesNotIncludedString.append(hgFile.getRelativePath());
                        filesNotIncludedString.append("</li>");
                    }
                    if (!this.mayCommitEverything(filesNotIncludedString.toString())) {
                        return exceptions;
                    }
                    VcsDirtyScopeManager dirtyManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
                    for (HgFile hgFile : changedFilesNotInCommit) {
                        dirtyManager.fileDirty(hgFile.toFilePath());
                    }
                }
            } else {
                command.setFiles(selectedFiles);
            }
            try {
                command.executeInCurrentThread();
            }
            catch (HgCommandException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        if (HgCommitAndPushExecutorKt.isPushAfterCommit(commitContext) && exceptions.isEmpty()) {
            ArrayList<HgRepository> preselectedRepositories = new ArrayList<HgRepository>(repositoriesMap.keySet());
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                HgRepository selectedRepo = (HgRepository)DvcsUtil.guessRepositoryForOperation((Project)this.myProject, (AbstractRepositoryManager)HgUtil.getRepositoryManager(this.myProject));
                new VcsPushDialog(this.myProject, preselectedRepositories, (Repository)selectedRepo).show();
            });
        }
        return exceptions;
    }

    private boolean isMergeCommit(VirtualFile repo) {
        return new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo).size() > 1;
    }

    private Set<HgFile> getChangedFilesNotInCommit(VirtualFile repo, Set<HgFile> selectedFiles) {
        List<HgRevisionNumber> parents = new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo);
        HgStatusCommand statusCommand = new HgStatusCommand.Builder(true).unknown(false).ignored(false).baseRevision(parents.get(0)).build(this.myProject);
        Set<HgChange> allChangedFilesInRepo = statusCommand.executeInCurrentThread(repo);
        HashSet<HgFile> filesNotIncluded = new HashSet<HgFile>();
        for (HgChange change : allChangedFilesInRepo) {
            HgFile beforeFile = change.beforeFile();
            HgFile afterFile = change.afterFile();
            if (!selectedFiles.contains(beforeFile)) {
                filesNotIncluded.add(beforeFile);
                continue;
            }
            if (selectedFiles.contains(afterFile)) continue;
            filesNotIncluded.add(afterFile);
        }
        return filesNotIncluded;
    }

    private boolean mayCommitEverything(String filesNotIncludedString) {
        int[] choice = new int[1];
        Runnable runnable = () -> {
            choice[0] = Messages.showOkCancelDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)HgBundle.message("hg4idea.commit.partial.merge.message", filesNotIncludedString)), (String)HgBundle.message("hg4idea.commit.partial.merge.title", new Object[0]), null);
        };
        ApplicationManager.getApplication().invokeAndWait(runnable);
        return choice[0] == 0;
    }

    public List<VcsException> scheduleMissingFileForDeletion(@NotNull List<? extends FilePath> files) {
        final ArrayList<HgFile> filesWithRoots = new ArrayList<HgFile>();
        for (FilePath filePath : files) {
            VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath);
            if (vcsRoot == null) continue;
            filesWithRoots.add(new HgFile(vcsRoot, filePath));
        }
        new Task.Backgroundable(this.myProject, HgBundle.message("files.removing.progress", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                new HgRemoveCommand(this.myProject).executeInCurrentThread(filesWithRoots);
            }
        }.queue();
        return null;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(@NotNull List<? extends VirtualFile> files) {
        new HgAddCommand(this.myProject).addWithProgress(files);
        return null;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return false;
    }

    @NotNull
    private Map<HgRepository, Set<HgFile>> getFilesByRepository(List<? extends Change> changes) {
        HashMap<HgRepository, Set<HgFile>> result = new HashMap<HgRepository, Set<HgFile>>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision != null) {
                this.addFile(result, afterRevision);
            }
            if (beforeRevision == null) continue;
            this.addFile(result, beforeRevision);
        }
        return result;
    }

    private void addFile(Map<HgRepository, Set<HgFile>> result, ContentRevision contentRevision) {
        FilePath filePath = contentRevision.getFile();
        HgRepository repo = HgUtil.getRepositoryForFile(this.myProject, contentRevision instanceof HgCurrentBinaryContentRevision ? ((HgCurrentBinaryContentRevision)contentRevision).getRepositoryRoot() : ChangesUtil.findValidParentAccurately((FilePath)filePath));
        if (repo == null) {
            return;
        }
        Set<HgFile> hgFiles = result.get(repo);
        if (hgFiles == null) {
            hgFiles = new HashSet<HgFile>();
            result.put(repo, hgFiles);
        }
        hgFiles.add(new HgFile(repo.getRoot(), filePath));
    }

    private void addRepositoriesWithoutChanges(@NotNull Map<HgRepository, Set<HgFile>> repositoryMap, @NotNull CommitContext commitContext) {
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(this.myProject);
        for (VcsRoot root : LocalChangesCommitterKt.getCommitWithoutChangesRoots((CommitContext)commitContext)) {
            HgRepository repository = root.getVcs() == this.myVcs ? (HgRepository)repositoryManager.getRepositoryForRoot(root.getPath()) : null;
            if (repository == null || repositoryMap.containsKey(repository)) continue;
            repositoryMap.put(repository, Collections.emptySet());
        }
    }

    public class HgCommitAdditionalComponent
    implements RefreshableOnComponent,
    AmendCommitModeListener,
    Disposable {
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final JCheckBox myCommitSubrepos;
        @NotNull
        private final CheckinProjectPanel myCommitPanel;
        @NotNull
        private final CommitContext myCommitContext;
        @Nullable
        private final ToggleAmendCommitOption myAmendOption;

        HgCommitAdditionalComponent(@NotNull CheckinProjectPanel panel, CommitContext commitContext, boolean hasSubrepos, boolean showAmendOption) {
            this.myCommitPanel = panel;
            this.myCommitContext = commitContext;
            this.myAmendOption = showAmendOption ? new ToggleAmendCommitOption(this.myCommitPanel, (Disposable)this) : null;
            this.myCommitSubrepos = new JCheckBox(HgBundle.message("repositories.commit.subs", new Object[0]), false);
            this.myCommitSubrepos.setVisible(hasSubrepos);
            this.myCommitSubrepos.setToolTipText(XmlStringUtil.wrapInHtml((CharSequence)HgBundle.message("repositories.commit.subs.tooltip", new Object[0])));
            this.myCommitSubrepos.addActionListener(e -> this.updateAmendState(!this.myCommitSubrepos.isSelected()));
            GridBag gb = new GridBag().setDefaultInsets((Insets)JBUI.insets((int)2)).setDefaultAnchor(17).setDefaultWeightX(1.0).setDefaultFill(2);
            this.myPanel = new JPanel(new GridBagLayout());
            if (this.myAmendOption != null) {
                this.myPanel.add((Component)this.myAmendOption, gb.nextLine().next());
            }
            this.myPanel.add((Component)this.myCommitSubrepos, gb.nextLine().next());
            this.getAmendHandler().addAmendCommitModeListener((AmendCommitModeListener)this, (Disposable)this);
        }

        @NotNull
        private AmendCommitHandler getAmendHandler() {
            return this.myCommitPanel.getCommitWorkflowHandler().getAmendCommitHandler();
        }

        public void dispose() {
        }

        public void amendCommitModeToggled() {
            this.updateCommitSubreposState();
        }

        public void saveState() {
            HgCommitOptionsKt.setCommitSubrepositories(this.myCommitContext, this.myCommitSubrepos.isSelected());
        }

        public void restoreState() {
            this.updateCommitSubreposState();
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public boolean isAmend() {
            return this.getAmendHandler().isAmendCommitMode();
        }

        private void updateCommitSubreposState() {
            boolean isAmendMode = this.isAmend();
            this.myCommitSubrepos.setEnabled(!isAmendMode);
            if (isAmendMode) {
                this.myCommitSubrepos.setSelected(false);
            }
        }

        private void updateAmendState(boolean enable) {
            this.getAmendHandler().setAmendCommitModeTogglingEnabled(enable);
            if (this.myAmendOption != null) {
                this.myAmendOption.setEnabled(enable);
            }
            if (!enable) {
                this.getAmendHandler().setAmendCommitMode(false);
            }
        }
    }
}

