/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.dvcs.ignore.VcsIgnoredFilesHolderBase;
import com.intellij.dvcs.ignore.VcsRepositoryIgnoredFilesHolder;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.ChangesViewRefresher;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgIgnoredFileHolder
extends VcsIgnoredFilesHolderBase<HgRepository> {
    public HgIgnoredFileHolder(@NotNull HgRepositoryManager manager) {
        super((AbstractRepositoryManager)manager);
    }

    @NotNull
    protected VcsRepositoryIgnoredFilesHolder getHolder(@NotNull HgRepository repository) {
        return repository.getIgnoredFilesHolder();
    }

    public static class Provider
    implements VcsManagedFilesHolder.Provider,
    ChangesViewRefresher {
        private final HgVcs myVcs;
        private final HgRepositoryManager myManager;

        public Provider(Project project) {
            this.myVcs = HgVcs.getInstance(project);
            this.myManager = HgUtil.getRepositoryManager(project);
        }

        @NotNull
        public AbstractVcs getVcs() {
            return this.myVcs;
        }

        @NotNull
        public VcsManagedFilesHolder createHolder() {
            return new HgIgnoredFileHolder(this.myManager);
        }

        public void refresh(@NotNull Project project) {
            this.myManager.getRepositories().forEach(r -> r.getIgnoredFilesHolder().startRescan());
        }
    }
}

