/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgCloneCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.HgCloneDialogComponent;
import org.zmlx.hg4idea.ui.HgCloneDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        FileDocumentManager.getInstance().saveAllDocuments();
        HgCloneDialog dialog = new HgCloneDialog(project);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.rememberSettings();
        String directoryName = dialog.getDirectoryName();
        String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        String parentDirectory = dialog.getParentDirectory();
        HgCheckoutProvider.doClone(project, listener, directoryName, sourceRepositoryURL, parentDirectory);
    }

    public static void doClone(final @NotNull Project project, final @Nullable CheckoutProvider.Listener listener, final @NotNull String directoryName, final @NotNull String sourceRepositoryURL, final @NotNull String parentDirectory) {
        VirtualFile destinationParent = LocalFileSystem.getInstance().findFileByIoFile(new File(parentDirectory));
        if (destinationParent == null) {
            return;
        }
        final String targetDir = destinationParent.getPath() + File.separator + directoryName;
        String projectPath = FileUtilRt.toSystemIndependentName((String)targetDir);
        CloneableProjectsService.CloneTask cloneTask = new CloneableProjectsService.CloneTask(){

            @NotNull
            public CloneableProjectsService.CloneTaskInfo taskInfo() {
                return new CloneableProjectsService.CloneTaskInfo(DvcsBundle.message((String)"cloning.repository", (Object[])new Object[]{sourceRepositoryURL}), DvcsBundle.message((String)"cloning.repository.cancel", (Object[])new Object[]{sourceRepositoryURL}), DvcsBundle.message((String)"clone.repository", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.tooltip", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.failed", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.canceled", (Object[])new Object[0]), DvcsBundle.message((String)"clone.stop.message.title", (Object[])new Object[0]), DvcsBundle.message((String)"clone.stop.message.description", (Object[])new Object[]{sourceRepositoryURL}));
            }

            @NotNull
            public CloneableProjectsService.CloneStatus run(@NotNull ProgressIndicator indicator) {
                HgCloneCommand clone = new HgCloneCommand(project);
                clone.setRepositoryURL(sourceRepositoryURL);
                clone.setDirectory(targetDir);
                HgCommandResult commandResult = clone.executeInCurrentThread();
                if (commandResult == null || HgErrorUtil.hasErrorsInCommandExecution(commandResult)) {
                    new HgCommandResultNotifier(project).notifyError("hg.clone.error", commandResult, DvcsBundle.message((String)"clone.repository.failed", (Object[])new Object[0]), HgBundle.message("hg4idea.clone.repo.error.msg", sourceRepositoryURL));
                    return CloneableProjectsService.CloneStatus.FAILURE;
                }
                DvcsUtil.addMappingIfSubRoot((Project)project, (String)targetDir, (String)"hg4idea");
                if (listener != null) {
                    listener.directoryCheckedOut(new File(parentDirectory, directoryName), HgVcs.getKey());
                    listener.checkoutCompleted();
                }
                return CloneableProjectsService.CloneStatus.SUCCESS;
            }
        };
        CloneableProjectsService.getInstance().runCloneTask(projectPath, cloneTask);
    }

    @NotNull
    public String getVcsName() {
        return HgBundle.message("hg4idea.vcs.name.with.mnemonic", new Object[0]);
    }

    @NotNull
    public VcsCloneComponent buildVcsCloneComponent(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        return new HgCloneDialogComponent(project, dialogStateListener);
    }
}

