/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.mq;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.mq.MqPatchDetails;
import org.zmlx.hg4idea.util.HgUtil;

public class HgMqAdditionalPatchReader {
    @NonNls
    private static final String HG_PATCH_PREFIX = "# HG changeset patch";
    @NonNls
    private static final String NODE_ID = "# Node ID ";
    @NonNls
    private static final String PARENT_ID = "# Parent ";
    @NonNls
    private static final String DATE = "# Date ";
    @NonNls
    private static final String BRANCH = "# Branch ";
    @NonNls
    private static final String USER = "# User ";
    @NonNls
    private static final String DIFF_INFO = "diff -";

    @NotNull
    public static MqPatchDetails readMqPatchInfo(@Nullable VirtualFile root, @Nullable File patchFile) {
        if (patchFile == null) {
            return MqPatchDetails.EMPTY_PATCH_DETAILS;
        }
        String context = DvcsUtil.tryLoadFileOrReturn((File)patchFile, (String)"");
        return HgMqAdditionalPatchReader.parseAdditionalMqInfo(root == null ? HgUtil.getNearestHgRoot(VfsUtil.findFileByIoFile((File)patchFile, (boolean)true)) : root, context);
    }

    @NotNull
    private static MqPatchDetails parseAdditionalMqInfo(@Nullable VirtualFile root, @NotNull String context) {
        String[] lines = StringUtil.splitByLines((String)context, (boolean)false);
        String user = null;
        Date date = null;
        String branch = null;
        ArrayList<String> messageLines = new ArrayList<String>();
        String nodeId = null;
        String parent = null;
        for (String line : lines) {
            if (line.startsWith(DIFF_INFO)) break;
            if (line.startsWith(NODE_ID)) {
                nodeId = HgMqAdditionalPatchReader.extractField(line, NODE_ID);
                continue;
            }
            if (line.startsWith(PARENT_ID)) {
                parent = HgMqAdditionalPatchReader.extractField(line, PARENT_ID);
                continue;
            }
            if (line.startsWith(DATE)) {
                date = HgMqAdditionalPatchReader.tryParseDate(HgMqAdditionalPatchReader.extractField(line, DATE));
                continue;
            }
            if (line.startsWith(BRANCH)) {
                branch = HgMqAdditionalPatchReader.extractField(line, BRANCH);
                continue;
            }
            if (line.startsWith(USER)) {
                user = HgMqAdditionalPatchReader.extractField(line, USER);
                continue;
            }
            if (line.startsWith("# ")) continue;
            messageLines.add(line);
        }
        return new MqPatchDetails(nodeId, parent, date, root, branch, StringUtil.join(messageLines, (String)"\n"), user);
    }

    @NotNull
    private static String extractField(@NotNull String line, @NotNull String prefix) {
        return line.substring(prefix.length()).trim();
    }

    @Nullable
    private static Date tryParseDate(@NotNull String substring) {
        try {
            return new Date(NumberFormat.getInstance().parse(substring).longValue() * 1000L);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public boolean isMqPatch(@NotNull File file) {
        return DvcsUtil.tryLoadFileOrReturn((File)file, (String)"").startsWith(HG_PATCH_PREFIX);
    }
}

