/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.UserNameRegex;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.log.HgRefManager;
import org.zmlx.hg4idea.repo.HgConfig;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgLogProvider
implements VcsLogProvider {
    private static final Logger LOG = Logger.getInstance(HgLogProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;

    public HgLogProvider(@NotNull Project project) {
        this.myProject = project;
        this.myRefSorter = new HgRefManager(project, (RepositoryManager<HgRepository>)HgLogProvider.getHgRepoManager(project));
        this.myVcsObjectsFactory = (VcsLogObjectsFactory)project.getService(VcsLogObjectsFactory.class);
    }

    @NotNull
    public VcsLogProvider.DetailedLogData readFirstBlock(@NotNull VirtualFile root, @NotNull VcsLogProvider.Requirements requirements) throws VcsException {
        List<VcsCommitMetadata> commits = HgHistoryUtil.loadMetadata(this.myProject, root, requirements.getCommitCount(), Collections.emptyList());
        return new LogDataImpl(this.readAllRefs(root), commits);
    }

    @NotNull
    public VcsLogProvider.LogData readAllHashes(@NotNull VirtualFile root, @NotNull Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        HashSet userRegistry = new HashSet();
        List<TimedVcsCommit> commits = HgHistoryUtil.readAllHashes(this.myProject, root, (Consumer<? super VcsUser>)new CollectConsumer(userRegistry), Collections.emptyList());
        for (TimedVcsCommit commit : commits) {
            commitConsumer.consume((Object)commit);
        }
        return new LogDataImpl(this.readAllRefs(root), userRegistry);
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsFullCommitDetails> commitConsumer) throws VcsException {
        HgVcs hgvcs = HgVcs.getInstance(this.myProject);
        assert (hgvcs != null);
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(true, hgvcs.getVersion());
        VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(this.myProject);
        if (factory == null) {
            return;
        }
        HgFileRevisionLogParser parser = new HgFileRevisionLogParser(this.myProject, HgHistoryUtil.getOriginalHgFile(this.myProject, root), hgvcs.getVersion());
        HgHistoryUtil.readLog(this.myProject, root, hgvcs.getVersion(), -1, HgHistoryUtil.prepareHashes(hashes), HgChangesetUtil.makeTemplate(templates), (Consumer<? super StringBuilder>)((Consumer)stringBuilder -> {
            HgFileRevision revision = (HgFileRevision)parser.convert(stringBuilder.toString());
            if (revision != null) {
                commitConsumer.consume((Object)HgHistoryUtil.createDetails(this.myProject, root, factory, revision));
            }
        }));
    }

    public void readMetadata(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        HgHistoryUtil.readCommitMetadata(this.myProject, root, hashes, consumer);
    }

    @NotNull
    private Set<VcsRef> readAllRefs(@NotNull VirtualFile root) {
        String tipRevision;
        if (this.myProject.isDisposed()) {
            return Collections.emptySet();
        }
        HgRepository repository = (HgRepository)HgLogProvider.getHgRepoManager(this.myProject).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return Collections.emptySet();
        }
        repository.update();
        Map<String, LinkedHashSet<Hash>> branches = repository.getBranches();
        Set<String> openedBranchNames = repository.getOpenedBranches();
        Collection<HgNameWithHashInfo> bookmarks = repository.getBookmarks();
        Collection<HgNameWithHashInfo> tags = repository.getTags();
        Collection<HgNameWithHashInfo> localTags = repository.getLocalTags();
        List<HgNameWithHashInfo> mqAppliedPatches = repository.getMQAppliedPatches();
        HashSet<VcsRef> refs = new HashSet<VcsRef>(branches.size() + bookmarks.size());
        for (Map.Entry<String, LinkedHashSet<Hash>> entry : branches.entrySet()) {
            String branchName = entry.getKey();
            boolean opened = openedBranchNames.contains(branchName);
            for (Hash hash : entry.getValue()) {
                refs.add(this.myVcsObjectsFactory.createRef(hash, branchName, opened ? HgRefManager.BRANCH : HgRefManager.CLOSED_BRANCH, root));
            }
        }
        for (HgNameWithHashInfo bookmarkInfo : bookmarks) {
            refs.add(this.myVcsObjectsFactory.createRef(bookmarkInfo.getHash(), bookmarkInfo.getName(), HgRefManager.BOOKMARK, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(this.myVcsObjectsFactory.createHash(currentRevision), "HEAD", HgRefManager.HEAD, root));
        }
        if ((tipRevision = repository.getTipRevision()) != null) {
            refs.add(this.myVcsObjectsFactory.createRef(this.myVcsObjectsFactory.createHash(tipRevision), "tip", HgRefManager.TIP, root));
        }
        for (HgNameWithHashInfo tagInfo : tags) {
            refs.add(this.myVcsObjectsFactory.createRef(tagInfo.getHash(), tagInfo.getName(), HgRefManager.TAG, root));
        }
        for (HgNameWithHashInfo localTagInfo : localTags) {
            refs.add(this.myVcsObjectsFactory.createRef(localTagInfo.getHash(), localTagInfo.getName(), HgRefManager.LOCAL_TAG, root));
        }
        for (HgNameWithHashInfo mqPatchRef : mqAppliedPatches) {
            refs.add(this.myVcsObjectsFactory.createRef(mqPatchRef.getHash(), mqPatchRef.getName(), HgRefManager.MQ_APPLIED_TAG, root));
        }
        return refs;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return HgVcs.getKey();
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        return this.myRefSorter;
    }

    @NotNull
    public Disposable subscribeToRootRefreshEvents(final @NotNull Collection<? extends VirtualFile> roots, final @NotNull VcsLogRefresher refresher) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(HgVcs.STATUS_TOPIC, (Object)new HgUpdater(){

            @Override
            public void update(Project project, @Nullable VirtualFile root) {
                if (root != null && roots.contains(root)) {
                    refresher.refresh(root);
                }
            }
        });
        return connection;
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) {
        VcsLogStructureFilter structureFilter;
        VcsLogTextFilter textFilter;
        VcsLogDateFilter dateFilter;
        VcsLogUserFilter userFilter;
        ArrayList<String> filterParameters = new ArrayList<String>();
        VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filterCollection.get(VcsLogFilterCollection.BRANCH_FILTER);
        if (branchFilter != null) {
            HgRepository repository = (HgRepository)HgLogProvider.getHgRepoManager(this.myProject).getRepositoryForRoot(root);
            if (repository == null) {
                LOG.error("Repository not found for root " + root);
                return Collections.emptyList();
            }
            Set<String> branchNames = repository.getBranches().keySet();
            List<String> bookmarkNames = HgUtil.getNamesWithoutHashes(repository.getBookmarks());
            List<String> predefinedNames = Collections.singletonList("tip");
            boolean atLeastOneBranchExists = false;
            for (String branchName : ContainerUtil.concat((Iterable[])new Iterable[]{branchNames, bookmarkNames, predefinedNames})) {
                if (!branchFilter.matches(branchName)) continue;
                filterParameters.add(HgHistoryUtil.prepareParameter("branch", branchName));
                atLeastOneBranchExists = true;
            }
            if (branchFilter.matches("HEAD")) {
                filterParameters.add(HgHistoryUtil.prepareParameter("branch", "."));
                filterParameters.add("-r");
                filterParameters.add("::.");
                atLeastOneBranchExists = true;
            }
            if (!atLeastOneBranchExists) {
                return Collections.emptyList();
            }
        }
        if ((userFilter = (VcsLogUserFilter)filterCollection.get(VcsLogFilterCollection.USER_FILTER)) != null) {
            filterParameters.add("-r");
            String authorFilter = StringUtil.join((Collection)ContainerUtil.map((Collection)ContainerUtil.map((Collection)userFilter.getUsers(root), VcsUserUtil::toExactString), (Function)UserNameRegex.EXTENDED_INSTANCE), (String)"|");
            filterParameters.add("user('re:" + authorFilter + "')");
        }
        if ((dateFilter = (VcsLogDateFilter)filterCollection.get(VcsLogFilterCollection.DATE_FILTER)) != null) {
            StringBuilder args = new StringBuilder();
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            filterParameters.add("-d");
            if (dateFilter.getAfter() != null) {
                if (dateFilter.getBefore() != null) {
                    args.append(dateFormatter.format(dateFilter.getAfter())).append(" to ").append(dateFormatter.format(dateFilter.getBefore()));
                } else {
                    args.append('>').append(dateFormatter.format(dateFilter.getAfter()));
                }
            } else if (dateFilter.getBefore() != null) {
                args.append('<').append(dateFormatter.format(dateFilter.getBefore()));
            }
            filterParameters.add(args.toString());
        }
        if ((textFilter = (VcsLogTextFilter)filterCollection.get(VcsLogFilterCollection.TEXT_FILTER)) != null) {
            String text = textFilter.getText();
            if (textFilter.isRegex()) {
                filterParameters.add("-r");
                filterParameters.add("grep(r'" + text + "')");
            } else if (textFilter.matchesCase()) {
                filterParameters.add("-r");
                filterParameters.add("grep(r'" + StringUtil.escapeChars((String)text, (char[])UserNameRegex.EXTENDED_REGEX_CHARS) + "')");
            } else {
                filterParameters.add(HgHistoryUtil.prepareParameter("keyword", text));
            }
        }
        if ((structureFilter = (VcsLogStructureFilter)filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER)) != null) {
            for (FilePath file : structureFilter.getFiles()) {
                filterParameters.add(file.getPath());
            }
        }
        return HgHistoryUtil.readHashes(this.myProject, root, (Consumer<? super VcsUser>)EmptyConsumer.getInstance(), maxCount, filterParameters);
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) {
        String userName = HgConfig.getInstance(this.myProject, root).getNamedConfig("ui", "username");
        if (userName == null && (userName = System.getenv("HGUSER")) == null && (userName = System.getenv("USER")) == null && (userName = System.getenv("LOGNAME")) == null) {
            return null;
        }
        Couple<String> userArgs = HgUtil.parseUserNameAndEmail(userName);
        return this.myVcsObjectsFactory.createUser((String)userArgs.getFirst(), (String)userArgs.getSecond());
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        return HgHistoryUtil.getDescendingHeadsOfBranches(this.myProject, root, commitHash);
    }

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile root) {
        HgRepository repository = (HgRepository)HgLogProvider.getHgRepoManager(this.myProject).getRepositoryForRootQuick(root);
        if (repository == null) {
            return null;
        }
        return repository.getCurrentBranchName();
    }

    @NotNull
    private static HgRepositoryManager getHgRepoManager(@NotNull Project project) {
        return (HgRepositoryManager)((Object)project.getService(HgRepositoryManager.class));
    }

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> property) {
        if (property == VcsLogProperties.CASE_INSENSITIVE_REGEX) {
            return (T)Boolean.FALSE;
        }
        return null;
    }
}

