/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.provider.HgChangeProvider;

class HgChangesParser
implements VcsChangesLazilyParsedDetails.ChangesParser {
    @NotNull
    private final HgRevisionNumber myRevisionNumber;

    HgChangesParser(@NotNull HgRevisionNumber revisionNumber) {
        this.myRevisionNumber = revisionNumber;
    }

    public List<Change> parseStatusInfo(@NotNull Project project, @NotNull VcsShortCommitDetails commit, @NotNull List<VcsFileStatusInfo> changes, int parentIndex) {
        ArrayList<Change> result = new ArrayList<Change>();
        for (VcsFileStatusInfo info : changes) {
            String filePath = info.getFirstPath();
            HgRevisionNumber parentRevision = this.myRevisionNumber.getParents().isEmpty() ? null : this.myRevisionNumber.getParents().get(parentIndex);
            Change change = switch (info.getType()) {
                default -> throw new IncompatibleClassChangeError();
                case Change.Type.MODIFICATION -> HgHistoryUtil.createChange(project, commit.getRoot(), filePath, parentRevision, filePath, this.myRevisionNumber, FileStatus.MODIFIED);
                case Change.Type.NEW -> HgHistoryUtil.createChange(project, commit.getRoot(), null, null, filePath, this.myRevisionNumber, FileStatus.ADDED);
                case Change.Type.DELETED -> HgHistoryUtil.createChange(project, commit.getRoot(), filePath, parentRevision, null, this.myRevisionNumber, FileStatus.DELETED);
                case Change.Type.MOVED -> HgHistoryUtil.createChange(project, commit.getRoot(), filePath, parentRevision, info.getSecondPath(), this.myRevisionNumber, HgChangeProvider.RENAMED);
            };
            result.add(change);
        }
        return result;
    }
}

