/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.project.Project;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQPushCommand {
    @NotNull
    private final HgRepository myRepository;

    public HgQPushCommand(@NotNull HgRepository repository) {
        this.myRepository = repository;
    }

    public void executeInCurrentThread(@NotNull String patchName) {
        Project project = this.myRepository.getProject();
        HgCommandResult result = new HgCommandExecutor(project).executeInCurrentThread(this.myRepository.getRoot(), "qpush", Arrays.asList("--move", patchName));
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(project).notifyError("hg.qpush.error", result, HgBundle.message("action.hg4idea.QPushAction.error", new Object[0]), HgBundle.message("action.hg4idea.QPushAction.error.msg", patchName));
        }
        this.myRepository.update();
    }
}

