/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgPromptCommandExecutor;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgUpdateCommand {
    private final Project project;
    private final VirtualFile repo;
    @NonNls
    private String revision;
    private boolean clean;

    public HgUpdateCommand(@NotNull Project project, @NotNull VirtualFile repo) {
        this.project = project;
        this.repo = repo;
    }

    public void setRevision(@NonNls String revision) {
        this.revision = revision;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    @Nullable
    public HgCommandResult execute() {
        HgCommandResult result;
        LinkedList<String> arguments = new LinkedList<String>();
        if (this.clean) {
            arguments.add("--clean");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        }
        HgPromptCommandExecutor executor = new HgPromptCommandExecutor(this.project);
        executor.setShowOutput(true);
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.project, (String)HgBundle.message("activity.name.update", new Object[0]));){
            String message;
            result = executor.executeInCurrentThread(this.repo, "update", arguments);
            if (!this.clean && HgErrorUtil.hasUncommittedChangesConflict(result) && HgUpdateCommand.showDiscardChangesConfirmation(this.project, message = XmlStringUtil.wrapInHtml((CharSequence)HgBundle.message("hg4idea.update.unable.to.merge", new Object[0]))) == 0) {
                arguments.add("-C");
                result = executor.executeInCurrentThread(this.repo, "update", arguments);
            }
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.repo});
        return result;
    }

    public static int showDiscardChangesConfirmation(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String confirmationMessage) {
        AtomicInteger exitCode = new AtomicInteger();
        UIUtil.invokeAndWaitIfNeeded(() -> exitCode.set(Messages.showOkCancelDialog((Project)project, (String)confirmationMessage, (String)HgBundle.message("hg4idea.update.uncommitted.problem", new Object[0]), (String)HgBundle.message("changes.discard", new Object[0]), (String)CommonBundle.message((String)"button.cancel.c", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())));
        return exitCode.get();
    }

    public static void updateTo(@NotNull @NonNls String targetRevision, @NotNull List<? extends HgRepository> repos, @Nullable Runnable callInAwtLater) {
        FileDocumentManager.getInstance().saveAllDocuments();
        for (HgRepository hgRepository : repos) {
            VirtualFile repository = hgRepository.getRoot();
            Project project = hgRepository.getProject();
            HgUpdateCommand.updateRepoTo(project, repository, targetRevision, callInAwtLater);
        }
    }

    public static void updateRepoTo(@NotNull Project project, @NotNull VirtualFile repository, @NotNull @NonNls String targetRevision, @Nullable Runnable callInAwtLater) {
        HgUpdateCommand.updateRepoTo(project, repository, targetRevision, false, callInAwtLater);
    }

    public static void updateRepoTo(final @NotNull Project project, final @NotNull VirtualFile repository, final @NotNull @NonNls String targetRevision, final boolean clean, final @Nullable Runnable callInAwtLater) {
        new Task.Backgroundable(project, HgBundle.message("action.hg4idea.updateTo.description", new Object[0])){

            public void onSuccess() {
                if (callInAwtLater != null) {
                    callInAwtLater.run();
                }
            }

            public void run(@NotNull ProgressIndicator indicator) {
                HgUpdateCommand.updateRepoToInCurrentThread(project, repository, targetRevision, clean);
            }
        }.queue();
    }

    public static boolean updateRepoToInCurrentThread(@NotNull Project project, @NotNull VirtualFile repository, @NotNull @NonNls String targetRevision, boolean clean) {
        HgUpdateCommand hgUpdateCommand = new HgUpdateCommand(project, repository);
        hgUpdateCommand.setRevision(targetRevision);
        hgUpdateCommand.setClean(clean);
        HgCommandResult result = hgUpdateCommand.execute();
        new HgConflictResolver(project).resolve(repository);
        boolean success = !HgErrorUtil.isCommandExecutionFailed(result);
        boolean hasUnresolvedConflicts = HgConflictResolver.hasConflicts(project, repository);
        if (!success) {
            new HgCommandResultNotifier(project).notifyError("hg.update.error", result, "", HgBundle.message("hg4idea.update.failed", new Object[0]));
        } else if (hasUnresolvedConflicts) {
            new VcsNotifier(project).notifyImportantWarning("hg.update.unresolved.conflicts.error", HgBundle.message("hg4idea.update.unresolved.conflicts", new Object[0]), HgBundle.message("hg4idea.update.warning.merge.conflicts", repository.getPath()));
        }
        HgUtil.getRepositoryManager(project).updateRepository(repository);
        HgUtil.markDirectoryDirty(project, repository);
        return success;
    }
}

