/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgDisposable;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.util.HgUtil;

public class HgAddCommand {
    private final Project myProject;

    public HgAddCommand(Project project) {
        this.myProject = project;
    }

    public void executeInCurrentThread(@NotNull Collection<? extends VirtualFile> files) {
        this.executeInCurrentThread(files, null);
    }

    public void addWithProgress(final Collection<? extends VirtualFile> files) {
        if (files.size() >= 100) {
            new Task.Backgroundable(this.myProject, HgBundle.message("hg4idea.add.progress", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    indicator.setIndeterminate(false);
                    HgAddCommand.this.executeInCurrentThread(files, indicator);
                }
            }.queue();
        } else {
            BackgroundTaskUtil.executeOnPooledThread((Disposable)HgDisposable.getInstance(this.myProject), () -> this.executeInCurrentThread(files));
        }
    }

    private void executeInCurrentThread(@NotNull Collection<? extends VirtualFile> files, @Nullable ProgressIndicator indicator) {
        Map<VirtualFile, Collection<VirtualFile>> sorted = HgUtil.sortByHgRoots(this.myProject, files);
        for (Map.Entry<VirtualFile, Collection<VirtualFile>> entry : sorted.entrySet()) {
            if (indicator != null) {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setFraction(0.0);
                indicator.setText2(HgBundle.message("hg4idea.add.files.progress", entry.getKey().getPresentableUrl()));
            }
            this.addFilesSynchronously(entry.getKey(), entry.getValue(), indicator);
        }
    }

    private void addFilesSynchronously(VirtualFile repo, Collection<? extends VirtualFile> files, @Nullable ProgressIndicator indicator) {
        List chunks = VcsFileUtil.chunkFiles((VirtualFile)repo, files);
        int currentChunk = 0;
        for (List paths : chunks) {
            if (indicator != null) {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setFraction((double)currentChunk / (double)chunks.size());
                ++currentChunk;
            }
            new HgCommandExecutor(this.myProject).executeInCurrentThread(repo, "add", paths);
        }
    }
}

