/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.CompareBranchesDialog;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.action.HgCompareWithBranchAction;
import org.zmlx.hg4idea.branch.HgCompareBranchesHelper;
import org.zmlx.hg4idea.branch.HgMultiRootBranchConfig;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchWorker {
    private static final String CURRENT_REVISION = ".";
    private static final Logger LOG = Logger.getInstance(HgBranchWorker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProgressIndicator myIndicator;

    HgBranchWorker(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        this.myProject = project;
        this.myIndicator = indicator;
    }

    public void compare(@NotNull String branchName, @NotNull List<HgRepository> repositories, @NotNull HgRepository selectedRepository) {
        try {
            CommitCompareInfo myCompareInfo = this.loadCommitsToCompare(repositories, branchName);
            ApplicationManager.getApplication().invokeLater(() -> this.displayCompareDialog(branchName, HgBranchWorker.getCurrentBranchOrRev(repositories), myCompareInfo, selectedRepository));
        }
        catch (VcsException e) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("hg.compare.with.branch.error", HgBundle.message("hg4idea.branch.compare.error", new Object[0]), e.getMessage());
        }
    }

    private void displayCompareDialog(@NotNull String branchName, @NotNull String currentBranch, @NotNull CommitCompareInfo compareInfo, @NotNull HgRepository selectedRepository) {
        if (compareInfo.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)HgBundle.message("hg4idea.branch.compare.no.changes.msg", currentBranch, branchName)), (String)HgBundle.message("hg4idea.branch.compare.no.changes", new Object[0]));
        } else {
            new CompareBranchesDialog((CompareBranchesHelper)new HgCompareBranchesHelper(this.myProject), branchName, currentBranch, compareInfo, (Repository)selectedRepository, false).show();
        }
    }

    @NotNull
    private static String getCurrentBranchOrRev(@NotNull Collection<HgRepository> repositories) {
        String currentBranch;
        if (repositories.size() > 1) {
            HgMultiRootBranchConfig multiRootBranchConfig = new HgMultiRootBranchConfig(repositories);
            currentBranch = multiRootBranchConfig.getCurrentBranch();
        } else {
            assert (!repositories.isEmpty()) : "No repositories passed to HgBranchOperationsProcessor.";
            HgRepository repository = repositories.iterator().next();
            currentBranch = repository.getCurrentBranchName();
        }
        return currentBranch == null ? CURRENT_REVISION : currentBranch;
    }

    @NotNull
    private CommitCompareInfo loadCommitsToCompare(List<HgRepository> repositories, String branchName) throws VcsException {
        CommitCompareInfo compareInfo = new CommitCompareInfo();
        for (HgRepository repository : repositories) {
            List<VcsFullCommitDetails> headToBranch = this.loadCommitsBetween(repository, CURRENT_REVISION, branchName);
            List<VcsFullCommitDetails> branchToHead = this.loadCommitsBetween(repository, branchName, CURRENT_REVISION);
            compareInfo.put((Repository)repository, headToBranch, branchToHead);
            compareInfo.putTotalDiff((Repository)repository, HgBranchWorker.loadTotalDiff(repository, branchName));
        }
        return compareInfo;
    }

    @NotNull
    private List<VcsFullCommitDetails> loadCommitsBetween(HgRepository repository, String fromRev, String toRev) throws VcsException {
        List<String> parameters = Arrays.asList("-r", "reverse(\"" + toRev + "\"%\"" + fromRev + "\")");
        return HgHistoryUtil.history(this.myProject, repository.getRoot(), -1, parameters, true);
    }

    @NotNull
    private static Collection<Change> loadTotalDiff(@NotNull HgRepository repository, @NotNull String branchName) throws VcsException {
        HgRevisionNumber branchRevisionNumber = HgCompareWithBranchAction.getBranchRevisionNumber(repository, branchName);
        VirtualFile root = repository.getRoot();
        List<Change> changes = HgUtil.getDiff(repository.getProject(), root, VcsUtil.getFilePath((VirtualFile)root), branchRevisionNumber, null);
        return DvcsBranchUtil.swapRevisions(changes);
    }
}

