/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action.mq;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentUtilEx;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgAbstractGlobalSingleRepoAction;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgMqUnAppliedPatchesPanel;

public final class HgShowUnAppliedPatchesAction
extends HgAbstractGlobalSingleRepoAction {
    @Override
    protected void execute(@NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo, @NotNull DataContext dataContext) {
        if (selectedRepo != null) {
            HgShowUnAppliedPatchesAction.showUnAppliedPatches(project, selectedRepo);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        HgRepository repository = this.getSelectedRepositoryFromEvent(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(repository != null && repository.getRepositoryConfig().isMqUsed());
    }

    public static void showUnAppliedPatches(@NotNull Project project, @NotNull HgRepository selectedRepo) {
        ToolWindow toolWindow = Objects.requireNonNull(ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control"));
        String tabName = selectedRepo.getRoot().getName();
        HgMqUnAppliedPatchesPanel patchesPanel = new HgMqUnAppliedPatchesPanel(selectedRepo);
        ContentUtilEx.addTabbedContent((ContentManager)toolWindow.getContentManager(), (JComponent)patchesPanel, (String)"MQ", HgBundle.messagePointer("hg4idea.mq.tab.name", new Object[0]), () -> tabName, (boolean)true, (Disposable)patchesPanel);
        toolWindow.activate(null);
    }
}

