/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgAbstractGlobalSingleRepoAction;
import org.zmlx.hg4idea.command.HgPullCommand;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgPullDialog;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPullAction
extends HgAbstractGlobalSingleRepoAction {
    @Override
    protected void execute(final @NotNull Project project, @NotNull Collection<HgRepository> repos, @Nullable HgRepository selectedRepo, @NotNull DataContext dataContext) {
        HgPullDialog dialog = new HgPullDialog(project, repos, selectedRepo);
        if (dialog.showAndGet()) {
            final String source = dialog.getSource();
            final HgRepository hgRepository = dialog.getRepository();
            new Task.Backgroundable(project, HgBundle.message("action.hg4idea.pull.progress", source), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    HgPullAction.executePull(project, hgRepository, source);
                    HgUtil.markDirectoryDirty(project, hgRepository.getRoot());
                }
            }.queue();
        }
    }

    private static void executePull(Project project, HgRepository hgRepository, String source) {
        HgPullCommand command = new HgPullCommand(project, hgRepository.getRoot());
        command.setSource(source);
        command.executeInCurrentThread();
        hgRepository.update();
    }
}

