/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgDisposable;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgInitCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.ui.HgInitAlreadyUnderHgDialog;
import org.zmlx.hg4idea.ui.HgInitDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgInit
extends DumbAwareAction {
    private Project myProject;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project == null || project.isDefault() || TrustedProjects.isTrusted((Project)project));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myProject = (Project)ObjectUtils.notNull((Object)((Project)e.getData(CommonDataKeys.PROJECT)), (Object)ProjectManager.getInstance().getDefaultProject());
        HgInitDialog hgInitDialog = new HgInitDialog(this.myProject);
        if (!hgInitDialog.showAndGet()) {
            return;
        }
        VirtualFile selectedRoot = hgInitDialog.getSelectedFolder();
        if (selectedRoot == null) {
            return;
        }
        VirtualFile vcsRoot = HgUtil.getNearestHgRoot(selectedRoot);
        VirtualFile mapRoot = selectedRoot;
        boolean needToCreateRepo = false;
        if (vcsRoot != null) {
            HgInitAlreadyUnderHgDialog dialog = new HgInitAlreadyUnderHgDialog(this.myProject, selectedRoot.getPresentableUrl(), vcsRoot.getPresentableUrl());
            if (!dialog.showAndGet()) {
                return;
            }
            if (dialog.getAnswer() == HgInitAlreadyUnderHgDialog.Answer.USE_PARENT_REPO) {
                mapRoot = vcsRoot;
            } else if (dialog.getAnswer() == HgInitAlreadyUnderHgDialog.Answer.CREATE_REPO_HERE) {
                needToCreateRepo = true;
            }
        } else {
            needToCreateRepo = true;
        }
        boolean finalNeedToCreateRepo = needToCreateRepo;
        VirtualFile finalMapRoot = mapRoot;
        BackgroundTaskUtil.executeOnPooledThread((Disposable)HgDisposable.getInstance(this.myProject), () -> {
            if (!finalNeedToCreateRepo || HgInit.createRepository(Objects.requireNonNull(this.myProject), selectedRoot)) {
                this.updateDirectoryMappings(finalMapRoot);
            }
        });
    }

    private void updateDirectoryMappings(VirtualFile mapRoot) {
        if (this.myProject != null && !this.myProject.isDefault() && this.myProject.getBaseDir() != null && VfsUtilCore.isAncestor((VirtualFile)this.myProject.getBaseDir(), (VirtualFile)mapRoot, (boolean)false)) {
            mapRoot.refresh(false, false);
            String path = mapRoot.equals(this.myProject.getBaseDir()) ? "" : mapRoot.getPath();
            ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)path, (String)"hg4idea"));
        }
    }

    public static boolean createRepository(@NotNull Project project, @NotNull VirtualFile selectedRoot) {
        HgCommandResult result = new HgInitCommand(project).execute(selectedRoot.getPath());
        if (!HgErrorUtil.hasErrorsInCommandExecution(result)) {
            VcsNotifier.getInstance((Project)project).notifySuccess("hg.repository.created", HgBundle.message("hg4idea.init.created.notification.title", new Object[0]), HgBundle.message("hg4idea.init.created.notification.description", selectedRoot.getPresentableUrl()));
            return true;
        }
        new HgCommandResultNotifier(project.isDefault() ? null : project).notifyError("hg.repo.creation.error", result, HgBundle.message("hg4idea.init.error.title", new Object[0]), HgBundle.message("hg4idea.init.error.description", selectedRoot.getPresentableUrl()));
        return false;
    }
}

