/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgAbstractGlobalSingleRepoAction;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgTagCreateCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgTagDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgCreateTagAction
extends HgAbstractGlobalSingleRepoAction {
    public void execute(final @NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo, @Nullable String reference) {
        final HgTagDialog dialog = new HgTagDialog(project, repositories, selectedRepo);
        if (dialog.showAndGet()) {
            try {
                new HgTagCreateCommand(project, dialog.getRepository(), dialog.getTagName(), reference).executeAsynchronously(new HgCommandResultHandler(){

                    @Override
                    public void process(@Nullable HgCommandResult result) {
                        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                            new HgCommandResultNotifier(project).notifyError("hg.tag.creation.error", result, HgBundle.message("hg4idea.branch.creation.error", new Object[0]), HgBundle.message("action.hg4idea.CreateTag.error.msg", dialog.getTagName()));
                        }
                    }
                });
            }
            catch (HgCommandException e) {
                HgErrorUtil.handleException(project, "hg.tag.creation.failed", e);
            }
        }
    }

    @Override
    protected void execute(@NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo, @NotNull DataContext dataContext) {
        this.execute(project, repositories, selectedRepo, "");
    }
}

