/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.google.common.collect.Iterables;
import com.intellij.dvcs.actions.DvcsCompareWithBranchAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCompareWithBranchAction
extends DvcsCompareWithBranchAction<HgRepository> {
    protected boolean nothingToCompare(@NotNull HgRepository repository) {
        Map<String, LinkedHashSet<Hash>> branches = repository.getBranches();
        if (branches.size() > 1) {
            return false;
        }
        Hash currentRevisionHash = HgCompareWithBranchAction.getCurrentHash(repository);
        List<HgNameWithHashInfo> other_bookmarks = HgCompareWithBranchAction.getOtherBookmarks(repository, currentRevisionHash);
        if (!other_bookmarks.isEmpty()) {
            return false;
        }
        return currentRevisionHash.equals(HgCompareWithBranchAction.getHeavyBranchMainHash(repository, repository.getCurrentBranch()));
    }

    @NotNull
    private static Hash getCurrentHash(@NotNull HgRepository repository) {
        String currentRevision = repository.getCurrentRevision();
        assert (currentRevision != null) : "Compare With Branch couldn't be performed for newly created repository";
        return HashImpl.build((String)repository.getCurrentRevision());
    }

    @NotNull
    private static List<HgNameWithHashInfo> getOtherBookmarks(@NotNull HgRepository repository, @NotNull Hash currentRevisionHash) {
        return ContainerUtil.filter(repository.getBookmarks(), info -> !info.getHash().equals(currentRevisionHash));
    }

    @Nullable
    private static Hash findBookmarkHashByName(@NotNull HgRepository repository, @NotNull String bookmarkName) {
        HgNameWithHashInfo bookmarkInfo = (HgNameWithHashInfo)ContainerUtil.find(repository.getBookmarks(), info -> info.getName().equals(bookmarkName));
        return bookmarkInfo != null ? bookmarkInfo.getHash() : null;
    }

    @Nullable
    private static Hash getHeavyBranchMainHash(@NotNull HgRepository repository, @NotNull String branchName) {
        LinkedHashSet<Hash> branchHashes = repository.getBranches().get(branchName);
        return branchHashes != null ? Objects.requireNonNull((Hash)Iterables.getLast(branchHashes)) : null;
    }

    @Nullable
    private static Hash detectActiveHashByName(@NotNull HgRepository repository, @NotNull String branchToCompare) {
        Hash refHashToCompare = HgCompareWithBranchAction.getHeavyBranchMainHash(repository, branchToCompare);
        return refHashToCompare != null ? refHashToCompare : HgCompareWithBranchAction.findBookmarkHashByName(repository, branchToCompare);
    }

    @NotNull
    protected List<String> getBranchNamesExceptCurrent(@NotNull HgRepository repository) {
        ArrayList<String> namesToCompare = new ArrayList<String>(repository.getBranches().keySet());
        String currentBranchName = repository.getCurrentBranchName();
        assert (currentBranchName != null);
        Hash currentHash = HgCompareWithBranchAction.getCurrentHash(repository);
        if (currentHash.equals(HgCompareWithBranchAction.getHeavyBranchMainHash(repository, currentBranchName))) {
            namesToCompare.remove(currentBranchName);
        }
        namesToCompare.addAll(HgUtil.getNamesWithoutHashes(HgCompareWithBranchAction.getOtherBookmarks(repository, currentHash)));
        return namesToCompare;
    }

    @NotNull
    protected HgRepositoryManager getRepositoryManager(@NotNull Project project) {
        return HgUtil.getRepositoryManager(project);
    }

    @NotNull
    protected Collection<Change> getDiffChanges(@NotNull Project project, @NotNull VirtualFile file, @NotNull String branchToCompare) throws VcsException {
        HgRepository repository = (HgRepository)this.getRepositoryManager(project).getRepositoryForFile(file);
        if (repository == null) {
            throw new VcsException(HgBundle.message("error.cannot.find.repository.for.file", file.getName()));
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        VirtualFile repositoryRoot = repository.getRoot();
        HgFile hgFile = new HgFile(repositoryRoot, filePath);
        HgRevisionNumber compareWithRevisionNumber = HgCompareWithBranchAction.getBranchRevisionNumber(repository, branchToCompare);
        List changes = HgUtil.getDiff(project, repositoryRoot, filePath, compareWithRevisionNumber, null);
        if (changes.isEmpty() && !HgCompareWithBranchAction.existInBranch(repository, filePath, compareWithRevisionNumber)) {
            throw new VcsException(HgCompareWithBranchAction.fileDoesntExistInBranchError((VirtualFile)file, (String)branchToCompare));
        }
        return changes.isEmpty() && !filePath.isDirectory() ? VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)HgContentRevision.create(project, hgFile, compareWithRevisionNumber)) : changes;
    }

    @NotNull
    public static HgRevisionNumber getBranchRevisionNumber(@NotNull HgRepository repository, @NotNull String branchName) throws VcsException {
        Hash refHashToCompare = HgCompareWithBranchAction.detectActiveHashByName(repository, branchName);
        if (refHashToCompare == null) {
            throw new VcsException(HgBundle.message("action.hg4idea.CompareWithBranch.cannot.detect.commit", branchName, repository.getRoot()));
        }
        return HgRevisionNumber.getInstance(branchName, refHashToCompare.toString());
    }

    private static boolean existInBranch(@NotNull HgRepository repository, @NotNull FilePath path, @NotNull HgRevisionNumber compareWithRevisionNumber) {
        HgStatusCommand statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(!path.isDirectory()).baseRevision(compareWithRevisionNumber).targetRevision(null).build(repository.getProject());
        statusCommand.cleanFilesOption(true);
        return !statusCommand.executeInCurrentThread(repository.getRoot(), Collections.singleton(path)).isEmpty();
    }
}

