/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandResult;

public final class HgCommandResultNotifier {
    private final Project myProject;

    public HgCommandResultNotifier(Project project) {
        this.myProject = project;
    }

    public void notifyError(@NonNls @Nullable String displayId, @Nullable HgCommandResult result, @NlsContexts.NotificationTitle @NotNull String failureTitle, @NlsContexts.NotificationContent @NotNull String failureDescription) {
        this.notifyError(displayId, result, failureTitle, failureDescription, null);
    }

    public void notifyError(@NonNls @Nullable String displayId, @Nullable HgCommandResult result, @NlsContexts.NotificationTitle @NotNull String failureTitle, @NlsContexts.NotificationContent @NotNull String failureDescription, NotificationListener listener) {
        List<Object> err = result != null ? result.getErrorLines() : Collections.emptyList();
        HtmlBuilder sb = new HtmlBuilder();
        if (!StringUtil.isEmptyOrSpaces((String)failureDescription)) {
            sb.append(failureDescription);
        } else {
            sb.append(failureTitle);
        }
        if (!err.isEmpty()) {
            sb.br();
            sb.appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map(err, HtmlChunk::text));
        }
        String errorMessage = sb.wrapWithHtmlBody().toString();
        VcsNotifier.getInstance((Project)this.myProject).notifyError(displayId, failureTitle, errorMessage, listener);
    }
}

