/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public abstract class HgAbstractGlobalAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        List<HgRepository> repositories = repositoryManager.getRepositories();
        if (repositories.isEmpty()) {
            return;
        }
        List<HgRepository> selectedRepositories = this.getSelectedRepositoriesFromEvent(event.getDataContext());
        this.execute(project, repositories, selectedRepositories, event.getDataContext());
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
    }

    protected abstract void execute(@NotNull Project var1, @NotNull Collection<HgRepository> var2, @NotNull List<HgRepository> var3, @NotNull DataContext var4);

    public boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        HgVcs vcs = Objects.requireNonNull(HgVcs.getInstance(project));
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        return roots != null && roots.length != 0;
    }

    @NotNull
    protected List<HgRepository> getSelectedRepositoriesFromEvent(@NotNull DataContext dataContext) {
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return Collections.emptyList();
        }
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        Object[] files = (VirtualFile[])ObjectUtils.notNull((Object)((VirtualFile[])dataContext.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)), (Object)VirtualFile.EMPTY_ARRAY);
        List selectedRepositories = ContainerUtil.mapNotNull((Object[])files, arg_0 -> ((HgRepositoryManager)repositoryManager).getRepositoryForFileQuick(arg_0));
        if (!selectedRepositories.isEmpty()) {
            return selectedRepositories;
        }
        HgRepository repository = HgUtil.guessRepositoryForOperation(project, dataContext);
        return repository != null ? Collections.singletonList(repository) : Collections.emptyList();
    }
}

