/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRevisionNumber
implements VcsRevisionNumber {
    private static final int SHORT_HASH_SIZE = 12;
    @NotNull
    private final String revision;
    @NotNull
    private final String changeset;
    @NotNull
    private final String commitMessage;
    @NotNull
    private final String author;
    @NotNull
    private final String email;
    @NotNull
    private final List<? extends HgRevisionNumber> parents;
    @NotNull
    private final String mySubject;
    private final boolean isWorkingVersion;
    public static final HgRevisionNumber NULL_REVISION_NUMBER = new HgRevisionNumber("", "", "", "", Collections.emptyList()){

        @Override
        public int compareTo(VcsRevisionNumber o) {
            return NULL.compareTo((Object)o);
        }

        @Override
        @NotNull
        public String asString() {
            return NULL.asString();
        }
    };

    public static HgRevisionNumber getInstance(@NotNull String revision, @NotNull String changeset, @NotNull String author, @NotNull String commitMessage) {
        return new HgRevisionNumber(revision, changeset, author, commitMessage, Collections.emptyList());
    }

    public static HgRevisionNumber getInstance(@NotNull String revision, @NotNull String changeset) {
        return new HgRevisionNumber(revision, changeset, "", "", Collections.emptyList());
    }

    public static HgRevisionNumber getInstance(@NotNull String revision, @NotNull String changeset, @NotNull List<? extends HgRevisionNumber> parents) {
        return new HgRevisionNumber(revision, changeset, "", "", parents);
    }

    public static HgRevisionNumber getLocalInstance(@NotNull String revision) {
        return new HgRevisionNumber(revision, "", "", "", Collections.emptyList());
    }

    public HgRevisionNumber(@NotNull String revision, @NotNull String changeset, @NotNull String authorInfo, @NotNull String commitMessage, @NotNull List<? extends HgRevisionNumber> parents) {
        this(revision, changeset, (String)HgUtil.parseUserNameAndEmail(authorInfo).getFirst(), (String)HgUtil.parseUserNameAndEmail(authorInfo).getSecond(), commitMessage, parents);
    }

    public HgRevisionNumber(@NotNull String revision, @NotNull String changeset, @NotNull String author, @NotNull String email, @NotNull String commitMessage, @NotNull List<? extends HgRevisionNumber> parents) {
        this.commitMessage = commitMessage;
        this.author = author;
        this.email = email;
        this.parents = parents;
        this.revision = revision.trim();
        this.changeset = changeset.trim();
        this.isWorkingVersion = changeset.endsWith("+");
        this.mySubject = HgBaseLogParser.extractSubject(commitMessage);
    }

    @NlsSafe
    @NotNull
    public String getChangeset() {
        return this.changeset;
    }

    @NlsSafe
    @NotNull
    public String getRevision() {
        return this.revision;
    }

    public long getRevisionAsLong() {
        return Long.parseLong(this.revision);
    }

    @NlsSafe
    @NotNull
    public String getCommitMessage() {
        return this.commitMessage;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        return this.author;
    }

    @NlsSafe
    @NotNull
    public String getEmail() {
        return this.email;
    }

    @NlsSafe
    @NotNull
    public String getAuthor() {
        return VcsUserUtil.getUserName((String)this.author, (String)this.email);
    }

    public boolean isWorkingVersion() {
        return this.isWorkingVersion;
    }

    @NotNull
    public String asString() {
        if (this.revision.isEmpty()) {
            return this.changeset;
        }
        return this.revision + ":" + this.changeset;
    }

    @NotNull
    public List<? extends HgRevisionNumber> getParents() {
        return this.parents;
    }

    public int compareTo(VcsRevisionNumber o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof HgRevisionNumber)) {
            return -1;
        }
        HgRevisionNumber other = (HgRevisionNumber)o;
        if (this.changeset.equals(other.changeset)) {
            return 0;
        }
        if (this.changeset.isEmpty()) {
            return 1;
        }
        if (other.changeset.isEmpty()) {
            return -1;
        }
        int revCompare = Long.valueOf(this.getRevisionNumber()).compareTo(Long.valueOf(other.getRevisionNumber()));
        if (revCompare != 0) {
            return revCompare;
        }
        if (HgRevisionNumber.getShortHash(this.changeset).equals(HgRevisionNumber.getShortHash(other.changeset))) {
            return 0;
        }
        if (this.isWorkingVersion) {
            return other.isWorkingVersion ? 0 : 1;
        }
        return other.isWorkingVersion ? -1 : 0;
    }

    private static String getShortHash(@NotNull String changeset) {
        return changeset.substring(0, 12);
    }

    public String getRevisionNumber() {
        if (this.isWorkingVersion) {
            return this.revision.substring(0, this.revision.length() - 1);
        }
        return this.revision;
    }

    public int hashCode() {
        return Objects.hash(this.revision, this.revision.isEmpty() ? this.changeset : HgRevisionNumber.getShortHash(this.changeset));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HgRevisionNumber)) {
            return false;
        }
        HgRevisionNumber that = (HgRevisionNumber)object;
        return this.compareTo(that) == 0;
    }

    public String toString() {
        return this.asString();
    }

    @NotNull
    public String getSubject() {
        return this.mySubject;
    }
}

