/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ArmoredInputStream;
import org.gradle.internal.impldep.org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPObjectFactory;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSignature;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSignatureList;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.gradle.security.internal.Fingerprint;

public class SecuritySupport {
    private static final Logger LOGGER = Logging.getLogger(SecuritySupport.class);
    private static final int BUFFER = 4096;
    public static final String KEYS_FILE_EXT = ".keys";

    public static void assertInitialized() {
    }

    public static boolean verify(File file, PGPSignature signature, PGPPublicKey publicKey) throws PGPException {
        signature.init(SecuritySupport.createContentVerifier(), publicKey);
        byte[] buffer = new byte[4096];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int len;
            while ((len = ((InputStream)in).read(buffer)) >= 0) {
                signature.update(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return signature.verify();
    }

    private static PGPContentVerifierBuilderProvider createContentVerifier() {
        return new BcPGPContentVerifierBuilderProvider();
    }

    public static PGPSignatureList readSignatures(File file) {
        PGPSignatureList pGPSignatureList;
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        try {
            pGPSignatureList = SecuritySupport.readSignatures(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((InputStream)stream).close();
        return pGPSignatureList;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PGPSignatureList readSignatures(InputStream source) {
        try (InputStream stream = source;){
            PGPSignatureList pGPSignatureList;
            block14: {
                InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)stream);
                try {
                    PGPObjectFactory objectFactory = new PGPObjectFactory(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                    pGPSignatureList = (PGPSignatureList)objectFactory.nextObject();
                    if (decoderStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (decoderStream != null) {
                        try {
                            decoderStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                decoderStream.close();
            }
            return pGPSignatureList;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String toLongIdHexString(long key) {
        return String.format("%016x", key).trim();
    }

    public static String toHexString(byte[] fingerprint) {
        return Fingerprint.wrap(fingerprint).toString();
    }

    public static List<PGPPublicKeyRing> loadKeyRingFile(File keyringFile) throws IOException {
        ArrayList<PGPPublicKeyRing> existingRings = new ArrayList<PGPPublicKeyRing>();
        try (InputStream ins = PGPUtil.getDecoderStream((InputStream)SecuritySupport.createInputStreamFor(keyringFile));){
            JcaPGPObjectFactory objectFactory = new JcaPGPObjectFactory(ins);
            try {
                for (Object o : objectFactory) {
                    if (!(o instanceof PGPPublicKeyRing)) continue;
                    existingRings.add((PGPPublicKeyRing)o);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error while reading the keyring file. {} keys read: {}", existingRings.size(), e.getMessage());
            }
        }
        return existingRings;
    }

    private static InputStream createInputStreamFor(File keyringFile) throws IOException {
        FileInputStream stream = new FileInputStream(keyringFile);
        if (keyringFile.getName().endsWith(KEYS_FILE_EXT)) {
            return new ArmoredInputStream((InputStream)stream);
        }
        return stream;
    }

    public static File asciiArmoredFileFor(File keyringsFile) {
        String baseName = keyringsFile.getName().substring(0, keyringsFile.getName().toLowerCase().lastIndexOf(".gpg"));
        return new File(keyringsFile.getParentFile(), baseName + KEYS_FILE_EXT);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.setProperty("crypto.policy", "unlimited");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

