/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.ContentFilteringRepository;
import org.gradle.api.internal.artifacts.repositories.RepositoryContentDescriptorInternal;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;

class PluginArtifactRepository
implements ArtifactRepositoryInternal,
ContentFilteringRepository,
ResolutionAwareRepository {
    private static final String REPOSITORY_NAME_PREFIX = "__plugin_repository__";
    private final ArtifactRepositoryInternal delegate;
    private final ResolutionAwareRepository resolutionAwareDelegate;
    private final RepositoryContentDescriptorInternal repositoryContentDescriptor;

    PluginArtifactRepository(ArtifactRepository delegate) {
        this.delegate = (ArtifactRepositoryInternal)delegate;
        this.resolutionAwareDelegate = (ResolutionAwareRepository)((Object)delegate);
        this.repositoryContentDescriptor = this.delegate.getRepositoryDescriptorCopy();
    }

    @Override
    public String getName() {
        return REPOSITORY_NAME_PREFIX + this.delegate.getName();
    }

    @Override
    public void setName(String name) {
        this.delegate.setName(name);
    }

    @Override
    public void content(Action<? super RepositoryContentDescriptor> configureAction) {
        configureAction.execute(this.repositoryContentDescriptor);
    }

    @Override
    public Action<? super ArtifactResolutionDetails> getContentFilter() {
        return this.repositoryContentDescriptor.toContentFilter();
    }

    @Override
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    @Override
    public ConfiguredModuleComponentRepository createResolver() {
        return this.resolutionAwareDelegate.createResolver();
    }

    @Override
    public RepositoryDescriptor getDescriptor() {
        return this.resolutionAwareDelegate.getDescriptor();
    }

    @Override
    public void onAddToContainer(NamedDomainObjectCollection<ArtifactRepository> container) {
        this.delegate.onAddToContainer(container);
    }

    @Override
    public RepositoryContentDescriptorInternal createRepositoryDescriptor() {
        return this.delegate.createRepositoryDescriptor();
    }

    @Override
    public RepositoryContentDescriptorInternal getRepositoryDescriptorCopy() {
        return this.repositoryContentDescriptor.asMutableCopy();
    }
}

