/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.Task;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.io.FileWriteMode;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeProblemBuilder;
import org.gradle.plugin.devel.tasks.internal.PropertyValidationAccess;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;

public abstract class ValidateAction
implements WorkAction<Params> {
    private static final Logger LOGGER = Logging.getLogger(ValidateAction.class);
    public static final String PROBLEM_SEPARATOR = "--------";

    @Override
    public void execute() {
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        final TreeMap taskValidationProblems = Maps.newTreeMap();
        final Params params = (Params)this.getParameters();
        params.getClasses().getAsFileTree().visit(new EmptyFileVisitor(){

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                ClassReader reader2;
                if (!fileDetails.getPath().endsWith(".class")) {
                    return;
                }
                try {
                    reader2 = new ClassReader(Files.asByteSource((File)fileDetails.getFile()).read());
                }
                catch (IOException e) {
                    throw new org.gradle.api.UncheckedIOException(e);
                }
                ArrayList classNames = Lists.newArrayList();
                reader2.accept((ClassVisitor)new TaskNameCollectorVisitor(classNames), 1);
                for (String className : classNames) {
                    Class<?> clazz;
                    try {
                        clazz = classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException | IllegalAccessError | NoClassDefFoundError | VerifyError e) {
                        LOGGER.debug("Could not load class: " + className, e);
                        continue;
                    }
                    ValidateAction.collectValidationProblems(clazz, taskValidationProblems, (Boolean)params.getEnableStricterValidation().get());
                }
            }
        });
        List<String> problemMessages = ValidateAction.toProblemMessages(taskValidationProblems);
        ValidateAction.storeResults(problemMessages, params.getOutputFile());
    }

    private static void collectValidationProblems(Class<?> topLevelBean, Map<String, Boolean> problems, boolean enableStricterValidation) {
        DefaultTypeValidationContext validationContext = Task.class.isAssignableFrom(topLevelBean) ? ValidateAction.createValidationContextAndValidateCacheableAnnotations(topLevelBean, CacheableTask.class, enableStricterValidation) : (TransformAction.class.isAssignableFrom(topLevelBean) ? ValidateAction.createValidationContextAndValidateCacheableAnnotations(topLevelBean, CacheableTransform.class, enableStricterValidation) : ValidateAction.createValidationContext(topLevelBean, enableStricterValidation));
        PropertyValidationAccess.collectValidationProblems(topLevelBean, validationContext);
        validationContext.getProblems().forEach((message2, severity) -> problems.put((String)message2, severity == Severity.ERROR));
    }

    private static DefaultTypeValidationContext createValidationContextAndValidateCacheableAnnotations(Class<?> topLevelBean, Class<? extends Annotation> cacheableAnnotationClass, boolean enableStricterValidation) {
        boolean cacheable = topLevelBean.isAnnotationPresent(cacheableAnnotationClass);
        DefaultTypeValidationContext validationContext = ValidateAction.createValidationContext(topLevelBean, cacheable || enableStricterValidation);
        if (enableStricterValidation) {
            ValidateAction.validateCacheabilityAnnotationPresent(topLevelBean, cacheable, cacheableAnnotationClass, validationContext);
        }
        return validationContext;
    }

    private static DefaultTypeValidationContext createValidationContext(Class<?> topLevelBean, boolean reportCacheabilityProblems) {
        return DefaultTypeValidationContext.withRootType(new DocumentationRegistry(), topLevelBean, reportCacheabilityProblems);
    }

    private static void validateCacheabilityAnnotationPresent(Class<?> topLevelBean, boolean cacheable, Class<? extends Annotation> cacheableAnnotationClass, DefaultTypeValidationContext validationContext) {
        if (topLevelBean.isInterface()) {
            return;
        }
        if (!cacheable && topLevelBean.getAnnotation(DisableCachingByDefault.class) == null && topLevelBean.getAnnotation(UntrackedTask.class) == null) {
            boolean isTask = Task.class.isAssignableFrom(topLevelBean);
            String cacheableAnnotation = "@" + cacheableAnnotationClass.getSimpleName();
            String disableCachingAnnotation = "@" + DisableCachingByDefault.class.getSimpleName();
            String untrackedTaskAnnotation = "@" + UntrackedTask.class.getSimpleName();
            String workType = isTask ? "task" : "transform action";
            validationContext.visitTypeProblem(problem -> {
                TypeProblemBuilder builder = (TypeProblemBuilder)((TypeProblemBuilder)((TypeProblemBuilder)((TypeProblemBuilder)((TypeProblemBuilder)((TypeProblemBuilder)((TypeProblemBuilder)problem.reportAs(Severity.WARNING)).withId(ValidationProblemId.NOT_CACHEABLE_WITHOUT_REASON)).forType(topLevelBean).withDescription("must be annotated either with " + cacheableAnnotation + " or with " + disableCachingAnnotation)).happensBecause("The " + workType + " author should make clear why a " + workType + " is not cacheable")).documentedAt("validation_problems", "disable_caching_by_default")).addPossibleSolution("Add " + disableCachingAnnotation + "(because = ...)")).addPossibleSolution("Add " + cacheableAnnotation);
                if (isTask) {
                    builder.addPossibleSolution("Add " + untrackedTaskAnnotation + "(because = ...)");
                }
            });
        }
    }

    private static void storeResults(List<String> problemMessages, RegularFileProperty outputFile) {
        if (outputFile.isPresent()) {
            File output = ((RegularFile)outputFile.get()).getAsFile();
            try {
                output.createNewFile();
                Files.asCharSink((File)output, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)Joiner.on((String)"\n--------\n").join(problemMessages));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    private static List<String> toProblemMessages(Map<String, Boolean> problems) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<String, Boolean> entry : problems.entrySet()) {
            String problem = entry.getKey();
            Boolean error = entry.getValue();
            builder.add((Object)String.format("%s: %s", Boolean.TRUE.equals(error) ? "Error" : "Warning", problem));
        }
        return builder.build();
    }

    private static class TaskNameCollectorVisitor
    extends ClassVisitor {
        private final Collection<String> classNames;

        public TaskNameCollectorVisitor(Collection<String> classNames) {
            super(589824);
            this.classNames = classNames;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if ((access & 1) != 0) {
                this.classNames.add(name.replace('/', '.'));
            }
        }
    }

    public static interface Params
    extends WorkParameters {
        public ConfigurableFileCollection getClasses();

        public RegularFileProperty getOutputFile();

        public Property<Boolean> getEnableStricterValidation();
    }
}

