/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.plugin.devel.tasks.internal.ValidateAction;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class ValidatePlugins
extends DefaultTask {
    public ValidatePlugins() {
        this.getEnableStricterValidation().convention(false);
        this.getIgnoreFailures().convention(false);
        this.getFailOnWarning().convention(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TaskAction
    public void validateTaskClasses() throws IOException {
        this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().setFrom(this.getClasses(), this.getClasspath())).submit(ValidateAction.class, params -> {
            params.getClasses().setFrom(this.getClasses());
            params.getOutputFile().set(this.getOutputFile());
            params.getEnableStricterValidation().set(this.getEnableStricterValidation());
        });
        this.getWorkerExecutor().await();
        List<String> problemMessages = ValidatePlugins.parseMessageList(Files.readAllLines(((RegularFile)this.getOutputFile().get()).getAsFile().toPath()));
        if (problemMessages.isEmpty()) {
            this.getLogger().info("Plugin validation finished without warnings.");
            return;
        } else if (((Boolean)this.getFailOnWarning().get()).booleanValue() || problemMessages.stream().anyMatch(line -> line.startsWith("Error:"))) {
            if (!((Boolean)this.getIgnoreFailures().get()).booleanValue()) throw WorkValidationException.forProblems(problemMessages).withSummary(helper -> "Plugin validation failed with " + helper.size() + helper.pluralize(" problem")).getWithExplanation(String.format("See %s for more information on how to annotate task properties.", this.getDocumentationRegistry().getDocumentationFor("more_about_tasks", "sec:task_input_output_annotations")));
            this.getLogger().warn("Plugin validation finished with errors. See {} for more information on how to annotate task properties.{}", this.getDocumentationRegistry().getDocumentationFor("more_about_tasks", "sec:task_input_output_annotations"), ValidatePlugins.toMessageList(problemMessages));
            return;
        } else {
            this.getLogger().warn("Plugin validation finished with warnings:{}", ValidatePlugins.toMessageList(problemMessages));
        }
    }

    private static List<String> parseMessageList(List<String> lines) {
        ArrayList list = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (line.equals("--------")) {
                list.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list;
    }

    private static CharSequence toMessageList(List<String> problemMessages) {
        StringBuilder builder = new StringBuilder();
        for (String problemMessage : problemMessages) {
            builder.append(String.format("%n  - %s", problemMessage));
        }
        return builder;
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getClasses();

    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    public abstract Property<Boolean> getIgnoreFailures();

    @Input
    public abstract Property<Boolean> getFailOnWarning();

    @Input
    public abstract Property<Boolean> getEnableStricterValidation();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Inject
    protected abstract DocumentationRegistry getDocumentationRegistry();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();
}

